<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>View Multi Sites</title>
<?php $this->load->view('head');?>
<meta http-equiv="refresh" content="20">
</head>
<body>
<?php $this->load->view('header');?>
<?php $this->load->view('side-bar');?>
<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="p-t-50">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="page-header">Multiple Sites</h3>
            </div>
        </div><!--/.row-->
    </div>

    <div class="row">
        <div class="col-md-12 store-data">
            <div class="panel panel-default">
                <div class="panel-body">
                    <table id="table_id" class="display">
                        <thead>
                        <tr>
                            <th>Domain</th>
                            <th>Site Status</th>
                            <th>View Multiple Sites</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($stores as $store): ?>
                            <tr>

                                <td><?php echo $this->MultipleStoreModel->getField('domain','cpanel',$store['cpanel_id']);?></td>
                                
                                
                                <td>
                                    <?php if($store['statuses_id'] == 1) {?>
                                        <p style="color: #00CC00">Ready to create</p>
                                    <?php }elseif($store['statuses_id'] == 2){?>
                                        <p style="color: #00CC00">Processing...</p>
                                    <?php } elseif($store['statuses_id'] == 3){?>
                                        <p style="color: #00CC00">Complete</p>
                                    <?php }?>
                                </td>

                                <td>
                                    <button class='load-in-modal btn btn-info btn-xs' data-url="<?php echo site_url().'MultipleSiteController/stores?id='.$store['id']?>">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                     <?php if($this->session->userdata('account_type') == 1) { 
                                     ?>
                                    
                                  <?php } ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div><!--/.row-->

    </div>

</div>


<!-- Modal -->
<div id="my-modal" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Sites</h4>
            </div>
            <div id="modal-body" class="modal-body">
                <p>Some text in the modal.</p>
            </div>
            <div class="modal-footer">
               
            </div>
        </div>

    </div>
</div>

<?php $this->load->view('footer');?>
<script type="text/javascript">
    $(document).ready( function () {
        $('#table_id').DataTable();
    } );
</script>

<script>
    $(document).on('click', '.load-in-modal', function (e) {
        e.preventDefault();

        var url = $(this).data('url');

        $('#modal-body').load(url, function () {
            $('#my-modal').modal('show');
        });
    });
</script>

<script>
    $(document).on('click', '.btn-del', function () {

        var url = $(this).data('url');
        // alert(url);
        swal({
            title: "Are you sure?",
            text: "Note : Your Store will be deleted, only this records will be erased.",
            icon: "error",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete) {
                    window.location.href = url;
                }
            });
    });

</script>

<script>
    $(document).on('click','.assign', function () {
        var url = $(this).data('url');
        // alert(url);
        $('#modal-body').load(url, function () {
            $('#my-modal').modal('show');
        });
    });
</script>

</body>
</html>