<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<?php include 'common/header.php'; ?>
<?php include 'common/headertop.php'; ?>

<div class="jumbotron">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="panel panel-default">
					<div class="panel-heading">
						<div class="panel-title">
		        			<h3>Create Notification</h3>
		  				</div>					
					</div>
					<form method="POST" id="create_notification">
						<div class="panel-body">
							<div class="form-group">
								<label for="field-4" class="col-sm-3 control-label">Title</label>
								<div class="col-sm-4 input-group">
									<span class="input-group-addon"><i class="fa fa-lock" aria-hidden="true"></i></span>
									<input type="text" class="form-control" id="title" Placeholder="Enter the title">
								</div>
							</div>
							<br/>
							<div class="form-group">
								<label for="field-4" class="col-sm-3 control-label">Message</label>
								<div class="col-sm-4 input-group">
									<span class="input-group-addon"><i class="fa fa-lock" aria-hidden="true"></i></span>
									<input type="text" class="form-control" id="message" Placeholder="Enter the message">
								</div>
							</div>
							<br/>

							<div class="form-group">
							<label for="field-9" class="col-sm-3 control-label">Enable/Disable</label>
							<label class="switch">
								<input type="checkbox" name="chk[]" id="chk[]" checked/>
							<div class="slider round"></div>
							</label>	
						</div>
						<br/>
							
			    	   <div class="form-group default-padding">
								<button id="" class="btn btn-lg btn-success largebutton">Create</button>
							</div>	
						</div>
					</form>
				</div>
			</div>
		</div>

		
		<div class="row">
			<div class="col-md-12">
				<div class="panel panel-default">
					<div class="panel-heading">
						<div class="panel-title">
		        			<h3>Notification Details</h3>
		  				</div>					
					</div>
					<div class="panel-body">
						<div class="table-responsive">
						<table class="table table-borders table-striped" style="overflow-x: scroll;">
							<thead>
								<th>User ID</th>
								<th>Title</th>
								<th>Message</th>
								<th>Role</th>
								<th>Status</th>
								<th>Created On</th>
								<th>Modified On</th>
                                <th>Actions</th>
							 </thead>
							<tbody>
						<?php 
						   
							if(isset($all_notification) && !empty($all_notification))
							{
								foreach ($all_notification as $key => $vd) {
									$id = $vd->id;
									$userid = $vd->userid;
									$title = $vd->title;
									$message = $vd->message;
									$usertype = $vd->source;
								    $status = $vd->status;
					                if($status == 0)
                                      $status_text = '<span class="label label-warning">Disabled</span>';
                                    if($status == 1)
                                      $status_text = '<span class="label label-success">Enabled</span>';

                   
                                    $created = $vd->created;
									$modified = $vd->modified;
									$url = base_url().'edit_notification/'.$id;
							 
								    echo "<tr>
									<td>$userid</td>
									<td>$title</td>
                                    <td>$message</td>
                                    <td>$usertype</td>
								    <td>$status_text</td>
									<td>$created</td>
									<td>$modified</td>
                                    <td><a href='$url'><button class='btn btn-primary'>Edit</button></a></td>

								   </tr>";
							

									
								}
							}	
						?>
					</tbody>
				</table>
			</div>
					</div>	
				</div>
			</div>
		</div>
   </div>
</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<script type="text/javascript">
//create notification
jQuery(document).on("submit","#create_notification", function(event){
    event.preventDefault();
    var title = jQuery("#title").val(); 
    var message = jQuery("#message").val(); 
    var accountype = jQuery('input[name="chk[]"]:checked').length > 0;
    if(accountype){
    	status = 1;
    }else{
        status = 0;
    }
    
    jQuery.ajax({
            url: baseurl + 'add_notification',
            method: 'POST',            
            data: {
                type: 'cp',title:title,message:message,status:status                              
                },
               
            success: function(remes){
                  var mydata = jQuery.parseJSON(remes);                    
                    if(mydata.status == 'success')
                    {                       
                        alert(mydata.message);
                        window.location.href = baseurl + "notification";                       
                    }
                    else
                    {  
                       alert(mydata.message);
                    }
                }
         });        
  
  return false;
});

</script>

<?php include 'common/footer.php'; ?>