<?php

class StoreModel extends CI_Model {
    
    public function __construct(){
       
        $this->load->database();
    }

    
    /* This function creates a new record in records table if $record_id is null
       if $records_id is not null then it creates new records in cpanel, amazon and wordpress
       tables and update records tables with id's of capnel, amazon and wordpress tables
    */
    public function save($table, $data, $record_id = null){
      if($record_id == ''){
			if($this->db->insert($table, $data))
			{
				$record_id = $this->db->insert_id();
				return  $record_id;
			}
		}

       else {
			 
            $this->db->insert($table, $data);
            $wordpress = array('wordpress_id' => $this->db->insert_id(),
							'step_1' => 1
						);

			$this->db->where('id',$record_id);
			$this->db->update('records',$wordpress);
		}
		   return false;
	}



    public function getmultiSiteRecords($data)
	{
		$query = $this->db->get_where('multiple_store_records',$data);
		return $query->result_array();
	}
	
	
	public function getmultiCategorySiteRecords($data){
	    
	    $query = $this->db->get_where('multiple_store_categories',$data);
		return $query->result_array();
	}
	
	
	
	
	

    /* fetch record data */
	public function getRecords($data)
	{
		$query = $this->db->get_where('records',$data);
		return $query->result_array();
	}
	
	public function getAmazonRecords($data){
	    
	  	$query = $this->db->get_where('amazon',$data);
		return $query->result_array();
	}
	
	
	
	
	
	
	public function getCategoryRecords($data){
	    
	    $query = $this->db->get_where('categories',$data);
		return $query->result_array();
	}
	
	
	public function getAmazonRegion($data){
	    
	    $query = $this->db->get_where('amazon_region',$data);
		return $query->result_array();
	}
	
	
	public function getWordpressRecords($data){
	    
	    $query = $this->db->get_where('wordpress',$data);
		return $query->result_array();
	 }


   
    /* This function update the records of records table */
    public function update_records($id, $data){
		if(!empty($id) && !empty($data))
		{	
			$this->db->where('id',$id);
			$this->db->update('records',$data);
			return true;
		}
		return false;
	}

    /* This function update the records in the amazon table */
    function update_amazon($id, $data)
	{
		if(!empty($id) && !empty($data))
		{	
			$this->db->where('id',$id);
			$this->db->update('amazon',$data);

			return true;
		}
		return false;
	}
	
	
	
	 public function insertData($table, $data){
          
           if($this->db->insert($table, $data))
			{
				$record_id = $this->db->insert_id();
				return  $record_id;
			}
		}




    /* This function returns the domain from cpanel row */
    function getDomainName($id)
	{
		if(!empty($id))
		{
			$this->db->select('domain');
		    $this->db->from('cpanel');
		    $this->db->where('id',$id);
		    $domain = $this->db->get()->row('domain');

            return $domain;
		}
		return false;
	}

    /* This function returns the category in amazon table */
    function getAmazonCategory($id)
	{
		if(!empty($id))
		{
			$this->db->select('category');
		    $this->db->from('amazon');
		    $this->db->where('id',$id);
		    return $this->db->get()->row('category');
		}
		return false;
	}

    /* This returns themes from table.*/

    function getThemes()
    {
        $query = $this->db->get('themes');
        return $query->result_array();
    }

   
  
    function updateData($id,$table, $data)
    {
        $this->db->where('id',$id);
        $this->db->update($table,$data);
        return true;
    }

    function getAll($table, $params, $limit = 20) {

        $filter_param = array();
        $join_table = array();

        foreach ($params as $key => $param) {

            $explode_param = explode('.', $key);

            if (count($explode_param) > 1) {
                $join_table[$explode_param[0]] = array(
                    $explode_param[1] => $param
                );
            } else {

                $filter_param[$key] = $param;
            }
        }

        $this->db->select('*');
        $this->db->from($table);
        foreach ($filter_param as $filter => $value) {
            $this->db->where($table.'.'.$filter, $value);
        }

        foreach ($join_table as $j_table => $column) {
            $this->db->join($j_table, $table.'.'.$j_table.'_'.'id = '.$j_table.'.id', 'inner');
            if (is_array($column)) {
                foreach ($column as $filter => $value) {
                    $this->db->where($j_table.'.'.$filter, $value);
                }
            }
        }
        $query = $this->db->get();



        return $query->result_array();
    }

    function getData($table, $params, $order='asc') {

        $this->db->order_by('id', $order);
        $query = $this->db->get_where($table,$params);

        return $query->result_array();
    }

    public function markFailed($table, $id, $message)
    {
        $this->db->where('id', $id);

        $data = array(
            'failed' => 1,
            'message' => $message
        );
        $this->db->update($table, $data);
    }

    
    public function updateStatusProcessingData($table, $id)
    {
        $status_slug = 'processing_data';

        $status = $this->db->get_where('statuses', array(
            'slug' => $status_slug
        ));

        if ($status->num_rows() == 0) {
            $status_title = ucwords(str_replace('_', ' ', $status_slug));
            $this->db->insert('statuses', array(
                'title' => $status_title,
                'slug' => $status_slug
            ));
            $status_id = $this->db->insert_id();
        } else {
            $status = $status->result_array();
            $status_id = $status[0]['id'];
        }

        $this->db->where('id', $id);
        $this->db->update($table, array(
            'statuses_id' => $status_id
        ));
    }

    public function getTable($table)
    {
        $query = $this->db->get($table);
        return $query->result_array();
    }

    /* This function returns the single value for the given field for given table. */
    public function getField($field, $table, $id)
    {
        $this->db->select($field);
        $this->db->from($table);
        $this->db->where('id',$id);
        return $this->db->get()->row($field);
    }

    /* This function checks whether the given data exists in the table or not.
     * if data exists in the table it will return true, else it will return false */
    public function exist($table, $data)
    {
        $query = $this->db->get_where($table,$data);
        if($query->num_rows() > 0)
        {
            return true;
        }
        return false;
    }

    /* This function delete records from the table */
    function delete($table, $param)
    {
        if($this->db->delete($table, $param))
        {
            return true;
        }
        return false;
    }

    function cron()
    {
        $this->db->select(' * FROM `records` WHERE `created` <= NOW() - INTERVAL 24 HOUR');
        $query = $this->db->get();
        return $query->result_array();
    }
}