<?php

class MultipleStoreModel extends CI_Model
{
    function __construct()
    {
        $this->load->database();
    }


    function save($table, $data)
    {
        $this->db->insert($table,$data);
        return $this->db->insert_id();
    }

    function getData($table, $params) {

        $query = $this->db->get_where($table,$params);

        return $query->result_array();
    }

    public function getField($field,$table,$id)
    {
        $this->db->select($field);
        $this->db->from($table);
        $this->db->where('id',$id);
        return $this->db->get()->row($field);
    }

    function updateData($id,$table, $data)
    {  
        $this->db->where('id',$id);  
        $this->db->update($table,$data);
        return true;
    }


    function getThemes()
    {
        $query = $this->db->get('themes');
        return $query->result_array();
    }

    /* This function delete records from the table */
    function delete($table, $param)
    {
        if($this->db->delete($table, $param))
        {
            return true;
        }
        return false;
    }

    function updatemulti_storeCategory($id,$table,$data)
    {

        $this->db->where('multiple_stores_id',$id);
        $this->db->update($table,$data);
        return true;
    }

    /* This function checks whether the given data exists in the table or not.
     * if data exists in the table it will return true, else it will return false. */
    public function exist($table, $data)
    {
        $query = $this->db->get_where($table,$data);
        if($query->num_rows() > 0)
        {
            return true;
        }
        return false;
    }



    public function getTable($table)
    {
        $query = $this->db->get($table);
        return $query->result_array();
    }

    public function getStoreRecords($id)
    {
       $SQL = "SELECT * FROM `multiple_stores` WHERE `multiple_store_records_id` = ".$id." ORDER BY id";
        $query = $this->db->query($SQL);

        return  $query->result_array();

    }


}