<?php
class Membershipmodel extends CI_Model{

	function validatelogin($username,$password){
		$this->db->where('email',$username);		
		$this->db->where('status','1');
		$query = $this->db->get('users');
		if($query->num_rows() == 1)
		{	
			$result = $query->result();			
			if(password_verify($password, $result[0]->password))
			{
				return $result[0]->id;
			}
			else
			{
				return 0;
			}
		}
		else
		{
			return 0;
		}

	} 
 
    
	function validateloginva($username,$password)
	{
		$this->db->where('email',$username);
		$this->db->where('status','1');
		$query = $this->db->get('virtual_accounts');
		if($query->num_rows() == 1)
		{
			$result = $query->result();
			if(password_verify($password, $result[0]->password))
			{
				$data['userid'] = $result[0]->user_id;
				$data['id'] = $result[0]->id;
				return $data;
			}
			else
			{
				return 0;
			}
		}
		else
		{
			return 0;
		}
	}


	function validateloginca($username,$password)
	{
		$this->db->where('email',$username);
		$this->db->where('status','1');
		$query = $this->db->get('client_accounts');
		if($query->num_rows() == 1)
		{
			$result = $query->result();
			if(password_verify($password, $result[0]->password))
			{
				$data['userid'] = $result[0]->user_id;
				$data['id'] = $result[0]->id;
				return $data;
			}
			else
			{
				return 0;
			}
		}
		else
		{
			return 0;
		}
	}
	


	 function exists($table, $data)
	{
		
		$query = $this->db->get_where($table,$data);
		$num_rows = ($query->num_rows());

		if($num_rows == 1)
		{
			return true;
		}
		return false;
	}	
    
    
    public function getTable($table, $order='ASC')
    {
        $this->db->order_by('id', $order);
        $query = $this->db->get($table);
        return $query->result_array();
    }

     function getStores($id,$table)
     {
        $query = $this->db->get_where($table,$id);
        return $query->result_array();
     }
    

     function isTokenValid($id, $cleanToken){
        $this->db->select('*');
        $this->db->from('users');
        $this->db->where('id',$id);
        $this->db->where('hash',$cleanToken);
        $this->db->where('status',1);
        $query = $this->db->get();
        if($query->num_rows() > 0){
            $row = $query->row_array();
            return $row;
        }
    }

	function validatelogin_sub_accounts($username,$password,$type)
	{
		$this->db->where('email',$username);		
		//$this->db->where('status','1');
		$query = $this->db->get($type);
		if($query->num_rows() == 1)
		{	
			$result = $query->result();			
			if(password_verify($password, $result[0]->password))
			{
				if($type == 'virtual_accounts')
				{
					return $result[0]->userid;
				}
				if($type == 'client_accounts')
				{									
					return $result[0]->id;
				}
			}
			else
			{
				return 0;
			}
		}
		else
		{
			return 0;
		}
	}
	 
   function check_is_admin_or_not($userid){
		$this->db->where('id',$userid);		
		$this->db->where('status','1');
		$this->db->where('is_admin','1');
		$query = $this->db->get('users');
		if($query->num_rows() == 1)
		{	
			 return 1;
		}
		else
		{
			return 0;
		}

	}

   
   public function getUser($data)
	{
		$query=$query = $this->db->get_where('users',$data);
		return $query->result_array();
	}

	function getCount($table, $data)
    {
        $query = $this->db->get_where($table,$data);
        $num_rows = ($query->num_rows());
        return $num_rows;
    }
    

    function getData($table, $params, $order='asc') {

        $this->db->order_by('id', $order);
        $query = $this->db->get_where($table,$params);

        return $query->result_array();
    }

    function graphDataSingleStore($id, $month)
    {
        $this->db->select('*');
        $this->db->from('records');
        $this->db->where('YEAR(created) = YEAR(NOW())');
        $this->db->where('MONTH(created)', $month);
        $this->db->where('user_id',$id);
        $query = $this->db->get();

        $num_rows = $query->num_rows();
        return $num_rows;
    }
   

   function graphDataMultiStore($user_id, $month)
    {
        $total_this_month = 0;

        $this->db->select('*');
        $this->db->from('multiple_store_records');
        $this->db->where('user_id',$user_id);
        $query = $this->db->get();

        foreach ($query->result_array() as $result) {
            $this->db->select('*');
            $this->db->from('multiple_stores');
            $this->db->where('multiple_store_records_id',$result['id']);
            $this->db->where('YEAR(created) = YEAR(NOW())');
            $this->db->where('MONTH(created)', $month);
            $query2 = $this->db->get();

            $total_this_month += $query2->num_rows();
        }

        return $total_this_month;
    }

   function resetPassword($email, $data)
	{

		$this->db->where('email',$email);
		$this->db->update('users',$data);

		return true;
	}

	function fetchtabledataone($tablename,$col,$colval){
		$this->db->where($col,$colval);
		$result = $this->db->get($tablename);
		$this->db->order_by("id", "desc");
		if($result->num_rows() >= 1)
		{
			foreach ($result->result() as $row) {
				$ret[] = $row;
			}

			if(isset($ret))
				return $ret;
		}
		else
			return 0;
	}

	function fetchtabledatatwocount($tablename,$col1,$colval1,$colval2){
		$this->db->select('id');
		$this->db->from($tablename);
		$this->db->where($col1,$colval1);
		$this->db->where('DATE(created)',$colval2);
		$result = $this->db->get();
		$this->db->order_by("id", "desc");
		if($result->num_rows() >= 1)
		{
			return $result->num_rows();
		}
		else
			return 0;
	}

   

    function save($table,$data)
     {
        $this->db->insert($table,$data);
        return $this->db->insert_id();
     }

   
    function update($table, $id, $data)
	{
		
		$this->db->where('id',$id);
		$this->db->update($table,$data);
		return true;
	}


	public function getField($field, $table, $id)
    {
        $this->db->select($field);
        $this->db->from($table);
        $this->db->where('id',$id);
        return $this->db->get()->row($field);
    }

	function fetchtabledatatwo($tablename,$col1,$colval1,$col2,$colval2){
		$this->db->where($col1,$colval1);
		$this->db->where($col2,$colval2);
		$result = $this->db->get($tablename);
		$this->db->order_by("id", "desc");
		if($result->num_rows() >= 1)
		{
			foreach ($result->result() as $row) {
				$ret[] = $row;
			}

			if(isset($ret))
				return $ret;
		}
		else
			return 0;
	}

    function searchTableDataTwo($tablename,$col1,$colval1,$col2,$colval2){
        $this->db->where($col1,$colval1);
        $this->db->like($col2,$colval2);
        $result = $this->db->get($tablename);
        $this->db->order_by("id", "desc");
        if($result->num_rows() >= 1)
        {
            foreach ($result->result() as $row) {
                $ret[] = $row;
            }

            if(isset($ret))
                return $ret;
        }
        else
            return 0;
    }


	function fetchtabledatathree($tablename,$col1,$colval1,$col2,$colval2,$col3,$colval3){
		$this->db->where($col1,$colval1);
		$this->db->where($col2,$colval2);
		$this->db->where($col3,$colval3);
		$result = $this->db->get($tablename);
		$this->db->order_by("id", "desc");
		if($result->num_rows() >= 1)
		{
			foreach ($result->result() as $row) {
				$ret[] = $row;
			}

			if(isset($ret))
				return $ret;
		}
		else
			return 0;
	}

	function fetchtabledatafour($tablename,$col1,$colval1,$col2,$colval2,$col3,$colval3,$col4,$colval4){
		$this->db->where($col1,$colval1);
		$this->db->where($col2,$colval2);
		$this->db->where($col3,$colval3);
		$this->db->where($col4,$colval4);		
		$result = $this->db->get($tablename);
		$this->db->order_by("id", "desc");
		if($result->num_rows() >= 1)
		{
			foreach ($result->result() as $row) {
				$ret[] = $row;
			}

			if(isset($ret))
				return $ret;
		}
		else
			return 0;
	}

	function fetchtabledatafourlimit($tablename,$col1,$colval1,$col2,$colval2,$col3,$colval3,$col4,$colval4,$limit){
		$this->db->where($col1,$colval1);
		$this->db->where($col2,$colval2);
		$this->db->where($col3,$colval3);
		$this->db->where($col4,$colval4);
		$this->db->limit($limit);
		$result = $this->db->get($tablename);
		$this->db->order_by("id", "desc");
		if($result->num_rows() >= 1)
		{
			foreach ($result->result() as $row) {
				$ret[] = $row;
			}

			if(isset($ret))
				return $ret;
		}
		else
			return 0;
	}


	function fetchalldata($tablename){
		$this->db->order_by("id", "desc");
		$result = $this->db->get($tablename);
		if($result->num_rows() >= 1)
		{
			foreach ($result->result() as $row) {
				$completerow[]= $row;
			}

			return $completerow;
		}

		else
			return 0;

	}

	
    function delete($table, $param)
    {
        if($this->db->delete($table, $param))
        {
            return true;
        }
        return false;
    }

	 function insertData($table='',$insertData=array())
	 {
	 			
		$result=$this->db->insert($table,$insertData);
		if($result)
			return $this->db->insert_id();
		else
			return 0;
	 }

	 function updatetable($table='', $updateData = array(), $col, $colval)
	 {
	 	$this->db->where($col, $colval);
        $check = $this->db->update($table, $updateData);        
        if($check)
        {
        	$this->db->select('id');
        	$this->db->where($col, $colval);
        	$ret = $this->db->get($table);        	
        	if($ret->num_rows() >= 1)
        	{        		
        		foreach ($ret->result()as $res) {
        			return $res->id;
        		}
        	}
        }
        else{
        	return 0;
        }
	 }

	function deleterows($tablename, $array){
		$done = $this->db->delete($tablename, $array); 
		if($done)
		{
			return 1;
		}	

		else{
			return 0;
		}
	}

	function deleterowsarray($tablename, $type, $array){
		$this->db->where_in($type, $array);
		$done = $this->db->delete($tablename);
		if($done)
		{
			return 1;
		}	

		else{
			return 0;
		}
	}


	function search($table,$coloumn,$search,$col,$colval)
	{
        $this->db->where($col,$colval);
        $this->db->like($coloumn, $search, 'both');
        $result = $this->db->get($table);
		if($result)
		{

			return $result->result();
		}
		else
		{			
			return 0;
		}
	}

	function checkforadata($table, $matchfile, $dataval)
	{
	 	$this->db->where($matchfile,$dataval);
		$result = $this->db->get($table);
		if(count($result->result()) >=1)
		{
			return 1;		
		}
		else
			return 0;
	}

	function jointable($maintable,$jointable, $jointablecol, $maintablecol,$col,$val,$select=null)
	{
		if($select == null)
			$this->db->select('*');
		else
			$this->db->select($select);
		$this->db->from($maintable);
		$this->db->join($jointable, $jointablecol.'='.$maintablecol);
		$this->db->where($col, $val);
		$result = $this->db->get();
		if($result->num_rows() >= 1)
		{
			foreach ($result->result() as $row) {
				$ret[] = $row;
			}

			if(isset($ret))
				return $ret;
		}
		else
			return 0;
	}
	function counttwo($tablename,$col1,$colval1,$col2,$colval2){
		$this->db->where($col1,$colval1);
		$this->db->where($col2,$colval2);
		$result = $this->db->get($tablename);
		$this->db->order_by("id", "desc");
		return $result->num_rows();
	}


	function count_two_date($tablename,$col1,$colval1,$col2,$colval2){
        $this->db->where($col1,$colval1);
        $this->db->where($col2,$colval2);
        $this->db->order_by("id", "desc");
        $result = $this->db->get($tablename);
		return $result->num_rows();
	}
	function count_one($tablename,$col1,$colval1){
		$this->db->where($col1,$colval1);
        $this->db->order_by("id", "desc");
		$result = $this->db->get($tablename);
		return $result->num_rows();
	}


    //validate admin login
    function validateAdminlogin($username,$password){
		$this->db->where('email',$username);		
		$this->db->where('status','1');
		$this->db->where('is_admin','1');
		$query = $this->db->get('users');
		if($query->num_rows() == 1)
		{	
			$result = $query->result();			
			if(password_verify($password, $result[0]->password))
			{
				return $result[0]->id;
			}
			else
			{
				return 0;
			}
		}
		else
		{
			return 0;
		}

	  }

	  public function show_data_date_range($data) {
         $condition = "created BETWEEN " . "'" . $data['date1'] . "'" . " AND " . "'" . $data['date2'] . "'";
         $this->db->select('*');
         $this->db->from('player_details');
         $this->db->where($condition);
         $query = $this->db->get();
         if ($query->num_rows() > 0) {
           return $query->result();
         }
         else 
         {
           return false;
         }
        }
    
     
     function fetchalldatawithcond($tablename,$col,$id){
		$this->db->where($col,$id);
		$this->db->order_by("id", "desc");
		$result = $this->db->get($tablename);
		if($result->num_rows() >= 1)
		{
			foreach ($result->result() as $row) {
				$completerow[]= $row;
			}
             	return $completerow;
		}
		else
			    return 0;
	    }

	 

      //user email existsor not
      function emailexits($tablename,$col,$email){
      	$this->db->where($col,$email);
	    $result = $this->db->get($tablename);
		if($result->num_rows() >= 1)
		{
			foreach ($result->result() as $row) {
				$completerow[]= $row;
			}
             	return $completerow;
		}
		else
			    return 0;
	    }



	   public function show_data_by_date_range($data,$table) {
         
         $condition = $this->db->where('created BETWEEN "'. date('Y-m-d', strtotime($data['date2'])). '" and "'. date('Y-m-d', strtotime($data['date1'])).'"');
         $this->db->select('*');
         $this->db->from($table);
         $this->db->where($condition);  
         $query = $this->db->get();    
        if ($query->num_rows() > 0) {
           return $query->result();
         }
         else 
         {
           return false;
         }
        }


       

        
       function insertuserlogData($table='',$insertData=array(),$colval){
	    $this->db->where('id',$colval);	
		$result=$this->db->insert($table,$insertData);
		if($result)
			return $this->db->insert_id();
		else
			return 0;
	    }

	    function fetchallactiveusersdata($tablename,$data){
		$this->db->where("login >", $data);
		$this->db->group_by("user_id");
		$result = $this->db->get($tablename);
		if($result->num_rows() >= 1)
		{
			foreach ($result->result() as $row) {
				$completerow[]= $row;
			}

			return $completerow;
		}

		else
			return 0;

	  
	  }


	  public function updateData($table,$user_id,$data)
      {
          $this->db->where('user_id',$user_id);
          $this->db->update($table,$data);
          return true;
      }


      public function updateSiteTemp($record_id,$data)
      {
          $this->db->where('record_id',$record_id);
          $this->db->update('single_site_temp',$data);
          return true;
      }


    public function activeUsersFromData($table,$to,$from)
    {
        $this->db->where("login <", $to);
        $this->db->where("login >", $from);
        $this->db->group_by("user_id");
        $result = $this->db->get($table);
        if($result->num_rows() >= 1)
        {
            foreach ($result->result() as $row) {
                $completerow[]= $row;
            }

            return $completerow;
        }

        else
            return 0;
    }


}
?>