<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use TBETool\PasswordGenerator;
require_once('library/wordpress/wp_hash/src/class-phpass.php');

/**
 * @property  upload
 */
class MultipleSiteController extends CI_Controller{
   
     public function __construct(){

          parent:: __construct();
          $this->load->library('Envato');
          $this->load->library('AmazonManager');
      }
      

    /**
     * Function: index
     *
     * This function loads the index page to create multiple stores
     *
     * @param : null
     *
     * @return : null
     */
    public function index(){
        
        if(!$this->is_logged_in()){
          
            redirect('login');
        }
        $id = $this->session->userdata('user_id');
        $data['cpanel_records'] = $this->MultipleStoreModel->getData('cpanel',array('user_id'=>$id));
        $data['amazon_records'] = $this->MultipleStoreModel->getData('amazon',array('user_id'=>$id));
        $data['envato_records'] = $this->MultipleStoreModel->getData('envato',array('user_id'=>$id));


        $this->load->view('multiplestore/index',$data);
    }

    
   
      /**
       * Function: createSites
       *
       * STEP 1: cPanel and Monetization Details this function save data in multiple_store_records table
       *
       * @param : null
       *
       * @return : null
       */
      public function createSites(){

          if(!$this->is_logged_in()){
          
            redirect('login');
          }

           if($this->input->post('submit'))
              {
                
                $data = array(
                              'user_id' => $this->session->userdata('user_id'),
                              'cpanel_id' => $this->input->post('cpanel_id'),
                              'envato_id' => $this->input->post('envato_id'),
                              'amazon_id' => $this->input->post('amazon_id'),
                              'no_of_stores' => $this->input->post('no_of_stores'),
                              'step_1' => 1
                        ); 
                if($id = $this->MultipleStoreModel->save('multiple_store_records',$data))
                  {
                     redirect('multiple_stores/details?id='.$id);
                  }
              }
        }


       
      
     


       /**
        * Function: storeDetails
        *
        * STEP 2: Niche Selection
        *
        * @param : null
        *
        * @return : null
        */
       public function storeDetails(){
          
          if(!$this->is_logged_in()){
          
            redirect('login');
          }
          $id = $this->input->get('id'); 
          $amazon_id = $this->MultipleStoreModel->getField('amazon_id','multiple_store_records',$id);
          $data['multi_store_id'] = $id;
          $data['no_of_stores'] = $this->MultipleStoreModel->getField('no_of_stores','multiple_store_records',$id);
          $region_id =$this->MultipleStoreModel->getField('region_id','amazon',$amazon_id);
          $cpanel_id = $this->MultipleStoreModel->getField('cpanel_id','multiple_store_records',$id);
          $domain = $this->MultipleStoreModel->getField('domain','cpanel',$cpanel_id);
          $explode = explode('.',$domain);
          $data['path'] = $explode[0];
          $data['domain'] =$domain;
          $data['categories'] = $this->MultipleStoreModel->getData('amazon_categories',array('region_id'=>$region_id));
          $data['video_categories'] = $this->StoreModel->getTable('video_categories');

          $this->load->view('multiplestore/store-details',$data);

      }




      /**
       * Function: saveStores
       *
       * This function stores the Niche Selection details (sites or blogs may have
         same or different username or passeord) in multiple_stores table
         and multiple_store_categories table and update status 1 for step2 in 
         multiple_store_records table
       *
       * @param : null
       *
       * @return : null
      */
      public function saveStores(){  
        
        if(!$this->is_logged_in()){
          
            redirect('login');
         }
        $multi_store_id = $this->input->post('multi_store_id');  
        
        $stores = $this->input->post('stores'); 
        
        foreach ($stores as $store)
        {
            //generate blog username, database and password
            $hash_password = $this->_generateWordpressHashPassword($store['blog_password']);
            $passwordGenerator = new PasswordGenerator(5, 1, 'lower_case,numbers');
            $wordpress_user_db = $passwordGenerator->generate();

            $passwordGenerator2 = new PasswordGenerator(12);
            $wordpress_db_pwd = $passwordGenerator2->generate();

            $data = array(
                          'multiple_store_records_id' => $multi_store_id,
                          'installation_path' => $store['installation_path'],
                          'blog_title' => $store['site_title'],
                          'username' => $store['blog_username'],
                          'password' => $store['blog_password'],
                          'hash_password' => $hash_password,
                          'db_username' => $wordpress_user_db,
                          'db_password' => $wordpress_db_pwd,
                          'db_name' => $wordpress_user_db
                    );
            
            $store_id = $this->MultipleStoreModel->save('multiple_stores',$data);

            if($store_id)
            {   
                $video_category = 1;
                $keyword = $store['keyword'];
                $total_products = $store['no_of_products'];
                
                if(empty($total_products)){
                        
                     $no_of_products = 0;
                 }
                    
                else
                  
                {
                   $no_of_products = $total_products;
                }
                      
                if(empty($keyword)){
                   
                    echo "Enter Keyword";
                    die;
                 }

                // Check Envato on Keyword before User Proceed on next Action
                $user_id = $this->session->userdata('user_id');
                $envato_post =  $this->StoreModel->getData('envato',array('user_id' => $user_id));
                $token = $envato_post[0]['access_token'];
                $ref_token = $envato_post[0]['refresh_token'];

                $no_of_products = $total_products;
                $newkeyword = urlencode($keyword);

                $last_date = strtotime($envato_post[0]['modified']);
                $curr_date = strtotime(date("Y-m-d h:i:s"));

                $hours = $curr_date - $last_date;

                // Need to Update user access token
                if($hours >= 3600 || $hours <= 0){

                    $refresh_token_res = $this->envato->refresh_access_token('https://api.envato.com/token',$ref_token);

                    if(empty($refresh_token_res->error)){
                        $data_envato['access_token'] = $refresh_token_res->access_token;
                        $data_envato['modified'] =  date("Y-m-d h:i:s");

                        $this->Membershipmodel->updateData('envato',$user_id,$data_envato);
                        $token = $refresh_token_res->access_token;
                    }
                }
                $url = 'https://api.envato.com/v1/discovery/search/search/item?page_size='.$no_of_products.'&term='.$newkeyword.'&site=codecanyon.net';

                $envato_data = $this->envato->fetch_products($url,$token);

                $envato_data_decode = json_decode($envato_data);

                if(empty($envato_data_decode->matches)){

                    $this->session->set_flashdata('error','No results found on this "'.$keyword.'" keyword');
                    redirect('multiple_stores/details?id='.$multi_store_id);
                }
                 
             }
              
            $storeArr = array('multiple_stores_id' => $store_id,
                              'user_id' => $this->session->userdata('user_id'),
                                'category' =>  $store['category'],
                              'video_category' => $video_category,
                              'no_of_products' => $no_of_products,
                              'keyword' => $keyword
                             );
            
            $this->MultipleStoreModel->save('multiple_store_categories',$storeArr);
          }

           $this->MultipleStoreModel->updateData($multi_store_id,'multiple_store_records',array('step_2'=>1));
           redirect('multiple_stores/themes?id='.$multi_store_id);
       }
    


       

     /**
      * Function: setThemes
      *
      * Get themes selected by user and update rows of 'multiple_stores' table with
     theme_id  and update status for step3 is 1 and for statuses_id (all steps) as 1
     in multiple_store_records table
      *
      * @param : null
      *
      * @return : null
      */
     
     public function setThemes(){ 
     
     if(!$this->is_logged_in()){
          
            redirect('login');
        }  
     $id = $this->input->post('id');   
     $themes = $this->input->post('selected_themes');

     foreach ($themes as $key => $value) {
       
      if(empty($value)) {

           $this->session->set_flashdata('error','Theme selection is required');
           redirect('multiple_stores/themes?id='.$this->input->post('id'));
       }
     
     }
     
//     $stores = $this->MultipleStoreModel->getData('multiple_stores', array('multiple_store_records_id'=>$id));
         $stores = $this->MultipleStoreModel->getStoreRecords($id);

     foreach ($stores as $key => $store)
      {  
          if(is_array($themes))
            {

            if (key_exists($key, $themes)) {

                  $data = array(
                      'theme_id' => $themes[$key]
                  );
              } else {

                  $data = array('theme_id' => 1);
              }
            } 

           else {
                    $data = array('theme_id' => 1);
                }


            $this->MultipleStoreModel->updateData($store['id'],'multiple_stores',$data);
         }

        
      $this->MultipleStoreModel->updateData($id,'multiple_store_records',array('step_3'=>1,'statuses_id'=>1));
        
      $stores = $this->MultipleStoreModel->getData('multiple_stores',array('multiple_store_records_id'=>$id));

      foreach ($stores as $store)
      {
          $recommend = $this->MultipleStoreModel->getField('recommend','themes',$store['theme_id']);
          
          if($recommend   == 1)
          {
              redirect('multiple_stores/buttons?id='.$id.'&store='.$store['id']);

          }
      }
            redirect('multiple_stores/site-logo?id='.$id);
      
     }

    /**
     * Function: setButtons
     *
     * This function will save user selected button and store button id in multiple_stores table
     *
     * @param : null
     *
     * @return : null
    */
    public function setButtons(){

        if(!$this->is_logged_in()){

            redirect('login');
        }
        $id = $this->input->post('id');
        $themes = $this->input->post('selected_themes');
        foreach ($themes as $key => $value) {

            if(empty($value)) {

                $this->session->set_flashdata('error','Button selection is required');
                redirect('multiple_stores/buttons?id='.$this->input->post('id'));
            }

        }

        $stores = $this->MultipleStoreModel->getData('multiple_stores', array('multiple_store_records_id'=>$id));
        foreach ($stores as $key => $store)
        {
            if(is_array($themes))
            {

                if (key_exists($key, $themes)) {

                    $data = array(
                        'button_id' => $themes[$key]
                    );
                } else {

                    $data = array('button_id' => 1);
                }
            }

            else {
                $data = array('button_id' => 1);
            }

            $this->MultipleStoreModel->updateData($store['id'],'multiple_stores',$data);
        }

        $this->MultipleStoreModel->updateData($id,'multiple_store_records',array('step_3'=>1,'statuses_id'=>1));

        redirect('multiple_stores/site-logo?id='.$id);


    }
     


     /**
      * Function: siteLogo
      *
      * This function stores the site logo and sites description for the site
      *
      * @param : null
      *
      * @return : null
      */
    public function siteLogo(){
      
      if(!$this->is_logged_in()){
          
            redirect('login');
        }
      if($this->input->post('submit')) {

          $logo_upload = 0;
        
        $record_id = $this->input->post('id');    
        $store_id = $this->input->post('store_id');  
        $themes = $this->input->post('stores');

        $stores = $this->MultipleStoreModel->getData('multiple_stores', array('multiple_store_records_id'=>$record_id));
            
         foreach ($stores as $key => $store)
          {
              $logo_url = $themes[$key]['logo_url'];
              $upload_url = $this->input->post('upload_url'.$key);


              if(empty($logo_url)){

                  if($_FILES['file'.$key]['name'] !='' || $upload_url == '') {

                      $config['upload_path'] = './uploads';
                      $config['allowed_types'] = 'gif|jpg|png';

                      $this->load->library('upload', $config);
                      $this->upload->initialize($config);

                      if (!$this->upload->do_upload('file' . $key)) {
                          $error = array('error' => $this->upload->display_errors());
                          $this->session->set_flashdata('error', $error['error']);

                          redirect('multiple_stores/site-logo?id=' . $record_id);
                      }

                      $logo_url = FCPATH . 'uploads/' . $_FILES['file' . $key]['name'];

                      // Upload Image on Amazon S3
                      try {
                          $amazon = new AmazonManager();
                          $amazon->connect(AWS_REGION, S3_ACCESS_KEY, S3_SECRET_KEY);
                          $s3_url = $amazon->s3Upload($logo_url, S3_BUCKET);

                          $logo_url = $s3_url;

                      } catch (Exception $e) {
                          $this->session->set_flashdata('error', $e->getMessage());
                          redirect('multiple_stores/site-logo?id=' . $record_id);
                      }

                  }else{
                      $logo_url = $upload_url;
                  }

                  $logo_upload = 1;

                  // Delete Image from local
                  unlink(FCPATH.'uploads/'.$_FILES['file'.$key]['name']);
              }

          
          if(is_array($themes))
          {

              if (key_exists($key, $themes)) {
                   
                   $data = array(
                       
                       'logo_url' =>  $logo_url,
                       'description' =>  $themes[$key]['description'],
                       'is_upload' => $logo_upload
                    );
              } 
           } 
                
               $this->MultipleStoreModel->updateData($store['id'],'multiple_stores',$data);
         }   
           
          $this->session->set_flashdata('success','Site creating process started');

          $command = "php ".FCPATH."index.php CreateMultiSiteCronController multipleSiteCreate > /dev/null &";
          exec($command);

          redirect('multiple_sites/view-sites');
            
        }
        
        $this->load->view('multiplestore/site-logo.php');
    }

    
    
  
    /**
     * Function: viewStores
     *
     * This function is used to view all multiple sites created by the user
     *
     * @param : null
     *
     * @return : null
     */
    public function viewStores(){
      
      if(!$this->is_logged_in()){
          
            redirect('login');
        }
      if($this->session->userdata('account_type') == 'team'){
         
          $id = array('user_id' => $this->session->userdata('user_id'));
          $data['stores'] = $this->MultipleStoreModel->getData('multiple_store_records', $id);

          $this->load->view('multiplestore/view-stores',$data);
        }
        elseif($this->session->userdata('account_type') == 'user')
        {
           $id = array('user_id' => $this->session->userdata('user_id'));
           $data['stores'] = $this->MultipleStoreModel->getData('multiple_store_records', $id);

           $this->load->view('multiplestore/view-stores',$data);
        }
        else
        {  
            die();
        }
     }


    

    /**
     * Function: editMultipleSite
     *
     * This function will allow to edit cPanel and Monetization Details
     *
     * @param : null
     *
     * @return : null
     */
    public function editMultipleSite(){
       
       if(!$this->is_logged_in()){
          
            redirect('login');
        }
      if($this->input->post('edit') == 'edit'){  
        
         $id = $this->input->post('site_record_id');
         $data = array(
                        'user_id' => $this->session->userdata('user_id'),
                        'cpanel_id' => $this->input->post('cpanel_id'),
                        'envato_id' => $this->input->post('envato_id'),
                        'no_of_stores' => $this->input->post('no_of_stores'),
                        'step_1' => 1
                      ); 

        if($this->MultipleStoreModel->updateData($id,'multiple_store_records',$data))
          {
             redirect('edit-site-category?id='.$id);
          }
       }

       else
       {

         $id = $this->session->userdata('user_id');  
         $multiple_site_record_id = $this->input->get('id');  

         //fetch data from multiple_store_records
         $get_record = $this->MultipleStoreModel->getData('multiple_store_records',array('id' => $multiple_site_record_id));  
         
         $data['user_id'] = $get_record[0]['user_id'];
         $data['site_record_id'] = $get_record[0]['id'];
         $data['cpanel_id'] = $get_record[0]['cpanel_id'];
         $data['envato_id'] = $get_record[0]['envato_id'];
         $data['no_of_stores'] = $get_record[0]['no_of_stores'];
         $data['cpanel_records'] = $this->StoreModel->getData('cpanel',array('user_id'=>$id));
         $data['envato_records'] = $this->StoreModel->getData('envato',array('user_id'=>$id));
          
         $this->load->view('multiplestore/edit_multiple_site.php',$data);
        }

      }

      

      /**
       * Function: editMultiSiteCategory
       *
       * This function will allow to edit keyword,no of products etc
       *
       * @param : null
       *
       * @return : null
      */
      public function editMultiSiteCategory(){  
        
        if(!$this->is_logged_in()){
          
            redirect('login');
        }
        if($this->input->post('edit') == 'edit'){
         
          $multi_store_id = $this->input->post('multi_store_id');  
          $stores = $this->input->post('stores');

          foreach ($stores as $store)
          {

            //generate blog username, database and password
            $hash_password = $this->_generateWordpressHashPassword($this->input->post('blog_password'));
            $passwordGenerator = new PasswordGenerator(5, 1, 'lower_case,numbers');
            $wordpress_user_db = $passwordGenerator->generate();

            $passwordGenerator2 = new PasswordGenerator(12);
            $wordpress_db_pwd = $passwordGenerator2->generate();

            $data = array(
                          'multiple_store_records_id' => $multi_store_id,
                          'installation_path' => $store['installation_path'],
                          'blog_title' => $store['site_title'],
                          'username' => $store['blog_username'],
                          'password' => $store['blog_password'],
                          'hash_password' => $hash_password,
                          'db_username' => $wordpress_user_db,
                          'db_password' => $wordpress_db_pwd,
                          'db_name' => $wordpress_user_db
                         );

            $store_id = $store['store_id'];
            $this->MultipleStoreModel->updateData($store_id,'multiple_stores',$data);

              $video_category = 1;
              $keyword = $store['keyword'];
              $total_products = $store['no_of_products'];

            if($store_id)
            {

                if(empty($total_products)){
                        
                     $no_of_products = 0;
                 }
                    
                else
                {
                     $no_of_products = $total_products;
                }
                      
                
               if(empty($keyword)){
                   
                    echo "Enter Keyword";
                    die;
                 }
                 
              }else{
                $store_id = $this->MultipleStoreModel->save('multiple_stores',$data);
            }


              // Check Envato on Keyword before User Proceed on next Action
              $user_id = $this->session->userdata('user_id');
              $envato_post =  $this->StoreModel->getData('envato',array('user_id' => $user_id));
              $token = $envato_post[0]['access_token'];
              $ref_token = $envato_post[0]['refresh_token'];

              $no_of_products = $total_products;
              $newkeyword = urlencode($keyword);

              $last_date = strtotime($envato_post[0]['modified']);
              $curr_date = strtotime(date("Y-m-d h:i:s"));

              $hours = $curr_date - $last_date;

              // Need to Update user access token
              if($hours >= 3600 || $hours <= 0){

                  $refresh_token_res = $this->envato->refresh_access_token('https://api.envato.com/token',$ref_token);

                  if(empty($refresh_token_res->error)){
                      $data_envato['access_token'] = $refresh_token_res->access_token;
                      $data_envato['modified'] =  date("Y-m-d h:i:s");

                      $this->Membershipmodel->updateData('envato',$user_id,$data_envato);
                      $token = $refresh_token_res->access_token;
                  }
              }
              $url = 'https://api.envato.com/v1/discovery/search/search/item?page_size='.$no_of_products.'&term='.$newkeyword.'&site=codecanyon.net';

              $envato_data = $this->envato->fetch_products($url,$token);

              $envato_data_decode = json_decode($envato_data);

              if(empty($envato_data_decode->matches)){
                  $this->session->set_flashdata('error','No results found on this "'.$keyword.'" keyword');
                  redirect('edit-site-category?id='.$multi_store_id);
              }

              $storeArr = array('multiple_stores_id' => $store_id,
                               'user_id' => $this->session->userdata('user_id'),
                                'category' =>  $store['category'],
                               'video_category' => $video_category,
                               'no_of_products' => $total_products,
                               'keyword' => $keyword
                             );

            $store_catg_id = $store['store_catg_id'];

            $this->MultipleStoreModel->updateData($store_catg_id, 'multiple_store_categories', $storeArr);


           }

          $this->MultipleStoreModel->updateData($multi_store_id,'multiple_store_records',array('step_2'=>1));
          redirect('multiple_stores/themes?id='.$multi_store_id);
        
      
        }
        
       else
        {

            $id = $this->input->get('id');
            $data['multi_store_id'] = $id;
            $amazon_id = $this->MultipleStoreModel->getField('amazon_id','multiple_store_records',$id);
            $data['no_of_stores'] = $this->MultipleStoreModel->getField('no_of_stores','multiple_store_records',$id);
            $region_id =$this->MultipleStoreModel->getField('region_id','amazon',$amazon_id);
            $cpanel_id = $this->MultipleStoreModel->getField('cpanel_id','multiple_store_records',$id);
            $domain = $this->MultipleStoreModel->getField('domain','cpanel',$cpanel_id);
            $explode = explode('.',$domain);
            $data['path'] = $explode[0];
            $data['domain'] =$domain;
            $data['categories'] = $this->MultipleStoreModel->getData('amazon_categories',array('region_id'=>$region_id));
            $data['video_categories'] = $this->StoreModel->getTable('video_categories');

            //fetch data  
            $data['multiple_stores'] = $this->MultipleStoreModel->getData('multiple_stores',array('multiple_store_records_id'=>$id));  


            $temp_arr = array();
            foreach($data['multiple_stores'] as $x => $val) {
             
               $rec_id =  $val['id'];
               $data['multiple_store_categories'] = $this->MultipleStoreModel->getData('multiple_store_categories',array('multiple_stores_id'=>$rec_id));

               $temp_arr[] = $data['multiple_store_categories'];
             }
            
            //fetch data
            $data['category_details'] = $temp_arr;


            $this->load->view('multiplestore/edit-store-details',$data);
      
         }
     }




      /**
       * Function: storeTiktalkArray
       *
       * create and store in an array for tiktalk embed data
       *
       * @param : null
       *
       * @return : null
       */
      public function storeTiktalkArray($totalResults,$data){
             
             if(!empty($data)){
                 $array = json_decode($data);
             } 
             
             
             $totalResults = $totalResults - 1 ;
             $array1= array();
             $dataArray = array();
             
             
             foreach($array as $i => $item) {
                 
                $getformatedurl = $array[$i];  
                $gettiktokembedurl = 'https://www.tiktok.com/oembed?url='.$getformatedurl;  
                $jsondatatiktokurl = $this->curl_file_get_contents($gettiktokembedurl); 
                $getembed = json_decode($jsondatatiktokurl);     
          
                if(empty($getembed->html)){
              
                }
          
               else
                {  
             
                  $dataArray['title'] = $getembed->title;   
                  $dataArray['getembedurl'] = $getembed->html;  
                  $dataArray['thumbnail_url'] = $getembed->thumbnail_url;  
                  array_push($array1,$dataArray); 
                } 
                 
             }
             
             return $array1;    
       }
     
     
     
    
      
      /**
       * Function: chooseThemes
       *
       * This function will display themes to user
       *
       * @param : null
       *
       * @return : null
      */
     public function chooseThemes(){
        
        $multi_store_id = $this->input->get('id');
        $data['no_of_stores'] = $this->MultipleStoreModel->getField('no_of_stores','multiple_store_records',$multi_store_id);
         
        $getRecordData['data'] = $this->MultipleStoreModel->getData('multiple_store_records',array('id'=>$multi_store_id));

        $cpanel_id = $getRecordData['data'][0]['cpanel_id'];
        $data['cpanelid'] = $this->MultipleStoreModel->getField('domain','cpanel',$cpanel_id);
        
        $getInstallationpath['data'] = $this->MultipleStoreModel->getData('multiple_stores',array('multiple_store_records_id'=>$multi_store_id)); 
        $totalSitesCount = count($getInstallationpath['data']);
        
        
        $data['themes'] = $this->MultipleStoreModel->getData('themes',array('recommend'=>0));
        
        $data['recommends'] = $this->MultipleStoreModel->getData('themes',array('recommend'=>1));
        
        $storeInstallationPathArray = array();
       
        foreach($getInstallationpath['data'] as  $sitepath){
            
             $site['records'] = array(
                                    'theme_id' => $sitepath['theme_id'],
                                    'siteId'=> $sitepath['id'],
                                    'installationpath' => $data['cpanelid'].'/'.$sitepath['installation_path'],
                                    'siteTitle' => $sitepath['blog_title']
                                   );
            
             $storeInstallationPathArray[] = $site['records'];
        }
        
       
        $sitesArray = array();
        $sitesArray['record_id'] = $multi_store_id;
        $sitesArray['allSitesData'] = $storeInstallationPathArray;   
        $sitesArray['themes'] = $data['themes']; 
        $sitesArray['recommends'] = $data['recommends'];


        $this->load->view('multiplestore/choose-themes',$sitesArray);
        
    }


    /**
     * Function: chooseButtons
     *
     * This function will allow user to select button
     *
     * @param : null
     *
     * @return : null
    */
    public function chooseButtons()
    {
        $multi_store_id = $this->input->get('id');
        $data['no_of_stores'] = $this->MultipleStoreModel->getField('no_of_stores','multiple_store_records',$multi_store_id);

        $getRecordData['data'] = $this->MultipleStoreModel->getData('multiple_store_records',array('id'=>$multi_store_id));

        $cpanel_id = $getRecordData['data'][0]['cpanel_id'];
        $data['cpanelid'] = $this->MultipleStoreModel->getField('domain','cpanel',$cpanel_id);

        $getInstallationpath['data'] = $this->MultipleStoreModel->getData('multiple_stores',array('multiple_store_records_id'=>$multi_store_id));
        $totalSitesCount = count($getInstallationpath['data']);


        $data['buttons'] = $this->MultipleStoreModel->getData('buttons',array('status'=>0));

        $storeInstallationPathArray = array();

        foreach($getInstallationpath['data'] as  $sitepath){

            $site['records'] = array(
                'button_id' => $sitepath['button_id'],
                'siteId'=> $sitepath['id'],
                'installationpath' => $data['cpanelid'].'/'.$sitepath['installation_path'],
                'siteTitle' => $sitepath['blog_title']
            );

            $storeInstallationPathArray[] = $site['records'];
        }


        $sitesArray = array();
        $sitesArray['record_id'] = $multi_store_id;
        $sitesArray['allSitesData'] = $storeInstallationPathArray;
        $sitesArray['buttons'] = $data['buttons'];


        $this->load->view('multiplestore/choose-buttons',$sitesArray);
    }
   
   
   
    
    /**
     * Function: action
     *
     * This function will manage all comman function
     *
     * @param : null
     *
     * @return : null
    */
    public function action(){

        $id = array('id' => $this->input->get('id'));

        $data = $this->MultipleStoreModel->getData('multiple_store_records',$id);
        if($data[0]['step_2'] == 0)
        {
            redirect('multiple_stores/details?id='.$this->input->get('id'));
        }
        elseif($data[0]['step_3'] == 0)
        {
            redirect('multiple_stores/themes?id='.$this->input->get('id'));
        }
    }

    

    /**
     * Function: _generateWordpressHashPassword
     *
     * This will hash the password entered by user and return hash password entered by user.
     *
     * @param : password
     *
     * @return : string
     */
    private function _generateWordpressHashPassword($password)
    {

        $wp_hasher = new PasswordHash(8, true);
        return $wp_hasher->HashPassword( trim($password) );
    }

    
    /**
     * Function: stores
     *
     * This function will display all created stores
     *
     * @param : null
     *
     * @return : null
    */
    public function stores(){
       
        $id = $this->input->get('id');
        $data['stores'] = $this->MultipleStoreModel->getData('multiple_stores',array('multiple_store_records_id'=>$id));
        $data['records'] = $this->MultipleStoreModel->getData('multiple_store_records',array('id'=>$id));
        $this->load->view('multiplestore/stores',$data);
    }


   
    /**
     * Function: delete_stores
     *
     * This function will delete all stores associate to single record.
     *
     * @param : null
     *
     * @return : null
     */
    public function delete_stores(){
       
        $id = $this->input->get('id');

        $multi_store_records = $this->MultipleStoreModel->getData('multiple_store_records',array('id'=>$id));
        
        // deleting multiple stores
        $stores = $this->MultipleStoreModel->getData('multiple_stores',array(
                 'multiple_store_records_id'=>$multi_store_records[0]['id']));

         foreach ($stores as $store)
            {
                $this->MultipleStoreModel->delete('multiple_store_categories',array('multiple_stores_id'=>$store['id']));
                $this->MultipleStoreModel->delete('multiple_stores',array('id'=>$store['id']));
            }

            $this->MultipleStoreModel->delete('multiple_store_records',array('id'=>$multi_store_records[0]['id']));

        $this->session->set_flashdata('success','Sites are deleted successfully');
        redirect('multiple_sites/view-sites');
    }





    /**
     * Function: assignUserList
     *
     * This function will list all the clients created by logged In user.
     *
     * @param  : null
     *
     * @return : null
     */
    public function assignUserList(){
        

        $data['store_id'] = $this->input->get('id'); 
        $user_id = $this->session->userdata('user_id'); 
        $data['clients'] = $this->MultipleStoreModel->getData('client_accounts',array('user_id'=>$user_id));  
        $this->load->view('multiplestore/assign-multi-store',$data);
     }

   

    /**
     * Function: multiStoreClientAssign
     *
     * This function will add single sites assign to client
     *
     * @param : null
     *
     * @return : boolen
    */
    public function multiStoreClientAssign(){
        
        if(!$this->is_logged_in()){
          
            redirect('login');
        }
        $id = $this->session->userdata('user_id');
        $data = array(
                   'client_id' => $this->input->post('client_id'),
                   'multiple_store_records_id' => $this->input->post('store_id'),
                   'user_id'=>$id
                ); 
        
        $site_assign_status = $this->input->post('multiple_site_status');
       

        if($this->StoreModel->exist('multiple_sites_assign_client',$data))
        {
            $result = $this->StoreModel->getData('multiple_sites_assign_client',$data);
            if(!empty($result[0]['id']))
            {
                $this->StoreModel->updateData($result[0]['id'],'multiple_sites_assign_client',array('is_multiple_sites'=>$site_assign_status));
            }
          else
           {
                 return false;
           }
         }
       else
        {
              $data['is_multiple_sites'] = 1;
              $data['is_site_assign_client_status'] = 1;
              $this->StoreModel->save('multiple_sites_assign_client',$data);
              return true;
        }
        
    }




    /**
     * Function: curl_file_get_contents
     *
     * This function will get a valid url and return json data
     *
     * @param : url
     *
     * @return : json
     */
    public function curl_file_get_contents($url){ 
        
        $curl = curl_init();
        $userAgent = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)';
        curl_setopt($curl,CURLOPT_URL,$url);
        curl_setopt($curl,CURLOPT_RETURNTRANSFER,TRUE);
        curl_setopt($curl,CURLOPT_CONNECTTIMEOUT,5);   
        curl_setopt($curl, CURLOPT_USERAGENT, $userAgent); 
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);  
        curl_setopt($curl, CURLOPT_AUTOREFERER, TRUE); 
        curl_setopt($curl, CURLOPT_TIMEOUT, 1500); 
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE); 
        $contents = curl_exec($curl);
        curl_close($curl);
        return $contents;
     }


      /**
       * Function : is_logged_in
       *
       * This function checks type of user logged in
       *
       * @param : null
       *
       * @return : boolen
       */
     public function is_logged_in(){
        
        if(isset($this->session->userdata['email']))
        {
            $userid = $this->session->userdata['user_id'];

            $row = $this->Membershipmodel->fetchtabledataone('users','id',$userid);

            if($row[0]->status == 1)
                return true;
            else
                return false;
        }
        else
        {

            return false;
         }
      }

     
     
 }