<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ClientAccountController extends CI_Controller
{
    function __construct()
    {
        parent:: __construct();
       
    }
    

    /**
     * Function: index
     *
     * This function will load client index page and display account data, cpanel data, store data etc
     *
     * @param : null
     *
     * @return : null
    */
    public function index()
     {
        $id = array('user_id' => $this->session->userdata('user_id'));
        $this->session->userdata('user_id');
        $data['stores'] = $this->Membershipmodel->getStores($id);
        $data['amazon'] = $this->Membershipmodel->getCount('envato',$id);
        $data['cpanel'] = $this->Membershipmodel->getCount('cpanel',$id);
        $data['single_stores'] = $this->Membershipmodel->getCount('records',$id);

        $multiple_store_records = $this->Membershipmodel->getData('multiple_store_records',$id);
        $data['multiple_stores'] = 0;

        foreach ($multiple_store_records as $store_record)
        {
            $data['multiple_stores'] = $data['multiple_stores'] + $this->Membershipmodel->getCount('multiple_stores',array('multiple_store_records_id'=>$store_record['id']));
        }

        // count single store data for Graph
        $data['graph_single'] = array();
        $data['graph_multi_stores'] = array();

        for ($i =1; $i <= 12; $i++)
        {
            $data['graph_single'][] = $this->Membershipmodel->graphDataSingleStore($id['user_id'],$i);

        }
        $data['graph_single'] = json_encode($data['graph_single']);

        for($i =1; $i <= 12; $i++)
        {
            $data['graph_multi_stores'][] = $this->Membershipmodel->graphDataMultiStore($id['user_id'],$i);
        }

        $data['graph_multi_stores'] = json_encode($data['graph_multi_stores']);

        $this->load->view('client/index',$data);
    }


    

    /**
     * Function: viewSingleStores
     *
     * This function renders the Single sites assigned by the parent user to the client
     *
     * @param : null
     *
     * @return : null
     */
    function viewSingleStores()
    {
        $id = array('user_id' => $this->session->userdata('user_id'));

        
        $client_stores = $this->Membershipmodel->getData('sites_assign_client',array(
                                                         'user_id'=>$id['user_id'],
                                                         'is_site_assign_client_status' => 1,
                                                         'is_single_site' => 1
                                                        ));

        $data['stores'] = array();

        foreach ($client_stores as $store)
        {  
            
            $data['stores'] = array_merge($data['stores'],
                $this->Membershipmodel->getData('records',array('wordpress_id'=>$store['wordpessId'])));
        }


        $this->load->view('client/view_single_sites',$data);
    }




    /**
     * Function: viewMultipleStores
     *
     * This function renders the Multiple sites assigned by the parent user to the client
     *
     * @param : null
     *
     * @return : null
     */
    function viewMultipleStores()
    {
        $id = array('user_id' => $this->session->userdata('user_id'));   
        $client_stores = $this->Membershipmodel->getData('multiple_sites_assign_client',array(
                                                          'user_id'=>$id['user_id'],
                                                          'is_site_assign_client_status' => 1,
                                                          'is_multiple_sites' => 1
                                                         ));
        
        $data['stores'] = array();

        foreach ($client_stores as $store)
        {   
            
            $data['stores'] = array_merge($data['stores'],
                $this->Membershipmodel->getData('multiple_store_records',array('id'=>$store['multiple_store_records_id'])));
        }
        
        $this->load->view('client/view_multiple_sites',$data);
    }




    /**
     * Function: sidebar
     *
     * This function will display side bar if user logged in else display 404
     *
     * @param : null
     *
     * @return : string
     */
    function sidebar()
    {
        $user = $this->Membershipmodel->getData('users',array('id'=>$this->session->userdata('user_id')));
        if($user[0]['is_client_account'] == 1)
        {
            return 'client/client_sidebar';

        } elseif ($user[0]['is_virtual_account'] == 1) {

            return 'client/client_sidebar';
        } else {
            return 'side-bar';
        }
    }

}