<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {
   
   function __construct()
    {
        parent::__construct();   
        $this->load->helper('url');
    }

    public function index() 
    {   
        $is_admin = $this->session->userdata('is_admin');
        if ($is_admin == 1) 
        {
                redirect('admin_dashboard');
        } 
        else 
        {
                redirect('login');
        }
    }


    
   /**
    * Function: dashboard
    *
    * This function will display users,users activity,total accounts, client etc
    *
    * @param : null
    *
    * @return : null
   */
    public function dashboard(){ 
        $is_admin = $this->session->userdata('is_admin');
        if($is_admin == 1)
        {   
        
        $user_stats = $this->Membershipmodel->fetchalldata('users');  
        $user_active = $this->Membershipmodel->fetchtabledataone('users','status','1'); 
        $enabled_users = $this->Membershipmodel->fetchtabledataone('users','status','1');  
        $disabled_users = $this->Membershipmodel->fetchtabledataone('users','status','0'); 
        $totalAmazonConnected = $this->Membershipmodel->fetchalldata('envato');
        $virtual_account = $this->Membershipmodel->fetchalldata('virtual_accounts'); 
        $client_accounts = $this->Membershipmodel->fetchalldata('client_accounts');  
        // $all_notifications = $this->Membershipmodel->fetchalldata('notification_admin'); 
        // $enabled_notifications = $this->Membershipmodel->fetchtabledataone('notification_admin','status','1');  
        $user_logs = $this->Membershipmodel->fetchalldata('login_logs');  
        
        $data['all_users'] = $user_stats; 

        if(!empty($user_logs)){
           $data['user_logs'] = count($user_logs); 
        }else{
           $data['user_logs'] = 0;
        }

        
        if(!empty($user_stats)){
           $data['user_count'] = count($user_stats); 
        }else{
           $data['user_count'] = 0;
        }
        
        
        if(!empty($user_active)){
           $data['user_active'] = count($user_active); 
        }else{
           $data['user_active'] = 0;
        }

        if(!empty($enabled_users)){
           $data['enabled_users'] = count($enabled_users); 
        }else{
           $data['enabled_users'] = 0;
        }

        if(!empty($disabled_users)){
           $data['disabled_users'] = count($disabled_users); 
        }else{
           $data['disabled_users'] = 0;
        }

        if(!empty($totalAmazonConnected)){
           $data['total_amazon_connected'] = count($totalAmazonConnected); 
        }else{
           $data['total_amazon_connected'] = 0;
        }

       
       if(!empty($all_notifications)){
           $data['all_notifications'] = count($all_notifications);
        }else{
           $data['all_notifications'] = 0;
        }

        if(!empty($enabled_notifications)){
           $data['enabled_notifications'] = count($enabled_notifications);
        }else{
           $data['enabled_notifications'] = 0;
        }

        if(!empty($virtual_account)){
           $data['virtual_account'] = count($virtual_account);
        }else{
           $data['virtual_account'] = 0;
        }
        
        if(!empty($client_accounts)){
           $data['client_account'] = count($client_accounts);
        }else{
           $data['client_account'] = 0;
        }
        
        $this->load->view('admin/dashboard.php',$data);   
        }
      else
       {
          $this->session->set_userdata('redirect', current_url());
          redirect('logout');
          die();
       }
        
    }



    /**
     * Function: add_user
     *
     * This function will check is user admin and load add users view page
     *
     * @param : null
     *
     * @return : null
    */
    public function add_user(){
          $is_admin = $this->session->userdata('is_admin');
          if($is_admin == 1)
          {
             $this->load->view('admin/add_user.php');       
          }
          else
          {
             redirect('login');
          }
        }
   
     

     /**
      * Function: randomPassword
      *
      * This function will generate a random password
      *
      * @param : null
      *
      * @return : string
     */
     public function randomPassword(){

        $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $pass = array(); 
        $alphaLength = strlen($alphabet) - 1; 
        for ($i = 0; $i < 22; $i++) {
            $n = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        return implode($pass); 
     }   
   
   

     /**
      * Function: add_new_user
      *
      * This function will allow admin to add users account
      *
      * @param : null
      *
      * @return : null
     */
     public function add_new_user(){ 

       if($this->input->is_ajax_request())
            {   
               if($this->input->post('type') == 'add_new_user'){   
                $email = $this->input->post('email'); 
                $check_email = $this->Membershipmodel->fetchtabledataone('users','email',$email);
                if($check_email != 0)
                {
                    $data['status'] = 'error';
                    $data['message'] = 'This email is already registered with us';
                    echo json_encode($data);die();
                }

                $insert['email'] = $this->input->post('email');
                $insert['username'] = $this->input->post('name');
                $password = $this->input->post('password');
                
                $options = array(
                 'salt' => $this->randomPassword(),
                 'cost' => 13 
                );
                $hash = password_hash($password, PASSWORD_DEFAULT, $options);

                $insert['password'] = $hash; 
                $insert['status'] = $this->input->post('status');
                $insert['is_admin'] = $this->input->post('is_admin');
                $insert['registered_by'] = 'Super Admin';
                $insert['created'] = date('Y-m-d H:i:s');
                $insert['modified'] = date('Y-m-d H:i:s');

                $done = $this->Membershipmodel->insertData('users',$insert);
                if($done != 0)
                {
                    $password = $hash;
                    $username = $this->input->post('name');
                    $email = $this->input->post('email');
                    $subject = '[IMPORTANT] Your Login Details for APP STORE';
                    $body = '<table align="center" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0" width="600" class="wrapper" style="width: 600px;">
    <tbody>
    <tr>
        <td align="center" valign="top" style="margin: 0px; padding: 0px;" class="responsive-cell">
            <table cellpadding="0" cellspacing="0" align="center" data-editable="image" data-mobile-stretch="1" style="" width="100%">
                <tbody>
                <tr>
                    <td valign="top" align="center" style="display: inline-block; padding: 10px 0px; margin: 0px;" class="tdBlock responsive-cell"><img createnew="true" src="https://m.gr-cdn-6.com/getresponse-Shhp/photos/697898604.png?img1540191220399" width="600" data-src="https://multimedia.getresponse.com/getresponse-Shhp/photos/697898604.png|600|180|600|180|0|0|1" data-origsrc="https://multimedia.getresponse.com/getresponse-Shhp/photos/692080604.png?_ga=2.69695696.1990658622.1533476252-514448715.1499576570" style="border-width: 0px; border-style: none; border-color: transparent; font-size: 12px; display: block;" class="mobile-image-stretch-enabled"></td>
                </tr>
                </tbody>
            </table>
        </td>
    </tr>
    <tr>
        <td align="left" valign="top" style="margin:0;padding:0;" class="responsive-cell">

            <table width="100%" border="0" cellpadding="0" cellspacing="0" align="center" data-editable="text" class="text-block">
                <tbody>
                <tr>
                    <td align="left" valign="top" class="lh-2" style="padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; color: rgb(38, 38, 38); line-height: 1.25; font-size: 16px;">
                        <div style="text-align: center;"><span style="font-weight: bold; background-color: rgb(230, 251, 87);"><br></span></div>
                        <div style="text-align: center;"><span style="font-weight: bold; background-color: rgb(230, 251, 87); text-decoration: underline;"><font style="font-size: 22px;" size="22">Congratulations on your purchase of Software Store Builder</font></span></div><br>You made the right decision and we\'re super excited to have you onboard and help your supercharge your video marketing, caption creation and translation.<br><br><span style="font-weight: bold; text-decoration: underline;">Here\'s your Access details for Software Store Builder Dashboard:</span><span style="background-color: transparent;">&nbsp;</span>
                        <div>
                            <div><br><span style="font-weight: bold;">Members Area:</span> <a href="https://app.softwarestorebuilder.com/" target="_blank" title="">https://app.softwarestorebuilder.com/</a><br><span style="font-weight: bold;">Username</span>: <?php echo $username?><br><span style="font-weight: bold;">Password</span>: <?php echo $password?><br><br>
                                <div style="text-align: center;"><span style="background-color: transparent; font-weight: bold;">Please feel free to reach out to our support</span></div>
                                <div style="text-align: center;"><span style="background-color: transparent; font-weight: bold;">team if you have any troubles logging in.</span></div><br>
                                <div style="text-align: center;"><span style="font-weight: bold;"><a href="http://support.vineasx.com" target="_blank" title="" style="background-color: transparent;">VineaSX Help Desk</a><span style="background-color: transparent;">&nbsp;or email us at support@vineasx.com</span></span>
                                </div><br><span style="font-weight: bold; text-decoration: underline;">[Training] Software Store Builder BONUS Traininig:</span>&nbsp;</div>
                            <div>In this exclusive training webinar <br>you will discover a lot of cool new<br>ways to leverage Software Store Builder to make<br>money.<br><br>Plus, tons of other cool prizes and <br>bonuses will be given away! <br><br>NOTE: only 1000 live seats are available <br>so make sure you register and mark <br>down the date before all spots are <br>taken! <br><br>It\'s very important you attend 5&nbsp;<br>minutes early in order to reserve <br>your spot. <br><br>We will be having a live Q &amp; A <br>session at the end of the webinar<br>to answer any of your questions you may have. <br><br>I\'m not sure if we can get a replay, <br>so it\'s very important you try your <br>best to attend this one time <br>exclusive training webinar.<br></div>
<!--                            <div><br><span style="font-weight: bold; text-decoration: underline;">Webinar on 22nd Nov @ 8:00PM EST</span></div>-->
                            <div><br></div>
                            <div><a href="https://app.softwarestorebuilder.com/tutorials" target="_blank" title="">https://app.softwarestorebuilder.com/tutorials</a><br><br>Help Desk: support@vineasx.com<br><br>If you need any help, feel free to get in touch.<br><br>We are here 24/7 to help you.<br><br>Please hit the reply button and let us know you\'re in. :)</div>
                            <div><br></div>
                        </div>
                    </td>
                </tr>
                </tbody>
            </table>
        </td>
    </tr>
    <tr>
        <td align="center" valign="top" style="margin: 0px; padding: 0px;" class="responsive-cell">
            <table cellpadding="0" cellspacing="0" align="center" data-editable="image" data-mobile-stretch="1" style="" width="100%">
                <tbody>
                <tr>
                    <td valign="top" align="center" style="display: inline-block; padding: 10px 0px; margin: 0px;" class="tdBlock responsive-cell"><img src="https://m.gr-cdn-6.com/getresponse-Shhp/photos/697898904.png?img1540191220399" width="600" data-src="https://multimedia.getresponse.com/getresponse-Shhp/photos/697898904.png|600|101|278|94|0|0|1" createnew="true" data-origsrc="https://multimedia.getresponse.com/getresponse-Shhp/photos/692082904.png?_ga=2.69695696.1990658622.1533476252-514448715.1499576570" style="border-width: 0px; border-style: none; border-color: transparent; font-size: 12px; display: block;" class="mobile-image-stretch-enabled"></td>
                </tr>
                </tbody>
            </table>
        </td>
    </tr>
    <tr>
        <td align="center" valign="top" style="margin: 0px; padding: 0px;" class="responsive-cell">
            <table width="100%" border="0" cellpadding="0" cellspacing="0" align="center" data-editable="text" class="text-block">
                <tbody>
                <tr>
                    <td align="left" valign="top" class="lh-1" style="padding: 10px; font-size: 16px; font-family: \'Times New Roman\', Times, serif; line-height: 1.15;"><span style="font-weight: bold; text-decoration: underline;">Navigation:</span> <a href="https://marketplace.vineasx.com" target="_blank" title="">VineaSX Marketplace</a> | <a href="https://www.abhineos.com" target="_blank" title="Abhi Dwivedi">The Blog</a> | <a href="https://www.twitter.com/lazyabhi" target="_blank" title="">Twitter</a> | <a href="http://support.vineasx.com" target="_blank" title="">Support</a>&nbsp;<br>
                        <div>&nbsp;</div>
                        <div>&nbsp;</div>
                        <div><br></div>
                        <div>&nbsp;</div>
                        <div>&nbsp;</div>
                    </td>
                </tr>
                </tbody>
            </table>
        </td>
    </tr>
    </tbody>
</table>';

                    $this->mail($email,$subject,$body);

                    $data['status'] = 'success';
                    $data['message'] = 'Account successfully created.';
                }
                else
                {   
                    $data['status'] = 'fail';
                    $data['message'] = 'Something went wrong. Please try again';
                }

                echo json_encode($data);
                die();
              }
           }
        }


        /**
         * Function : mail
        */

        public function mail($to,$subject,$body){

            $config = Array(

                'protocol' => 'smtp',
                'smtp_host' => '',
                'smtp_port' => 80,
                'smtp_user' => '',
                'smtp_pass' => '',
                'smtp_timeout' => '4',
                'mailtype' => 'html',
                'charset' => 'iso-8859-1'
            );

            $this->load->library('email', $config);
            $this->email->set_newline("\r\n");
            $this->email->from('', '  ');

            $this->email->to($to); // replace it with receiver mail id

            $this->email->subject($subject); // replace it with relevant subject

            $this->email->message($body);

            $this->email->send();

        }
      


      /**
       * Function: edit_user
       *
       * This function will take one arrgument and allow admin to edit user account
       *
       * @param : userid
       *
       * @return : null
      */
       public function edit_user($userid){
         
       $is_admin = $this->session->userdata('is_admin');
       if($is_admin == 1) {  
       $userid = $this->uri->segment(2);
       if($userid){
       $user_details = $this->Membershipmodel->fetchtabledataone('users','id',$userid);
       if(!empty($user_details)){
       $data['user_details'] = $user_details;
       $data['amazon_details'] = $this->Membershipmodel->fetchalldatawithcond('amazon','user_id',$userid);  
       $data['client_accounts'] = $this->Membershipmodel->fetchalldatawithcond('client_accounts','user_id',$userid);  
       $data['virtual_accounts'] = $this->Membershipmodel->fetchalldatawithcond('virtual_accounts','user_id',$userid);
         
       $newArr = array();
       $arr = array();
       $arr['records'] = $this->Membershipmodel->fetchalldatawithcond('records','user_id',$userid);  
       
       if(!empty($arr['records'])){
       foreach($arr['records'] as $x => $val) {
          
         $record_id = $val->id;  
         $user_id = $val->user_id;
         $blog_title = $val->blog_title;
         $installation_path = $val->installation_path;
         
         $arr1 = array(
                 
                  'site_id' => $record_id,
                  'user_id' => $user_id,
                  'blog_title' => $blog_title,
                  'installation_path' => $installation_path,
                  'installation_path' => $installation_path,
                  
                   );
                   
         $cpanel_id = $val->cpanel_id;
         $cpanel_details = $this->Membershipmodel->fetchtabledataone('cpanel','id',$cpanel_id);
         $cpanel_domain = $cpanel_details[0]->domain;
         $cpanel_domain_status = $cpanel_details[0]->status;
           
         $arr2 = array(
                   
                   'cpanel_domain' => $cpanel_domain,
                   'cpanel_domain_status' => $cpanel_domain_status
                 
                    );
        
          $arr3 = array_merge($arr1,$arr2);
            
            
           
          $amazon_id = $val->amazon_id;
           
           
           $amazon_details = $this->Membershipmodel->fetchtabledataone('amazon','id',$amazon_id); 
           
           if(!empty($amazon_details[0])){
           $amazon_region_id = $amazon_details[0]->region_id; 
           $amazon_affiliate_tag = $amazon_details[0]->affiliate_tag;
           $amazon_access_key = $amazon_details[0]->access_key;
           $amazon_account_status = $amazon_details[0]->status;
           }
           else
           {
              $amazon_region_id = ''; 
              $amazon_affiliate_tag = '';
              $amazon_access_key = '';
              $amazon_account_status = '';
           }
           
           $arr4 = array(
                     
                     'amazon_region_id' => $amazon_region_id,
                     'amazon_affiliate_tag' => $amazon_affiliate_tag,
                     'amazon_access_key' => $amazon_access_key,
                     'amazon_account_status' => $amazon_account_status
                   
                      );
           
           $arr5 = array_merge($arr3,$arr4);     
           
           $wordpress_id = $val->wordpress_id;
           
           //get wordpress details
           $wordpress_details = $this->Membershipmodel->fetchtabledataone('wordpress','id',$wordpress_id); 
           $site_username = $wordpress_details[0]->username;
           $sitepassword = $wordpress_details[0]->password;
           
           $arr6 = array(
                     
                     'site_username' => $site_username,
                     'sitepassword' => $sitepassword
                    
                     );
                     
           $arr7 = array_merge($arr5,$arr6);    
           
           $theme_id = $val->theme_id;
           
           //get theme details
           $theme_details = $this->Membershipmodel->fetchtabledataone('themes','id',$theme_id);
           if(!empty($theme_details[0])){
           $theme_name = $theme_details[0]->name;  
           }
           else
           {
             $theme_name = '';
           }
           
           $step_1 = $val->step_1;
           $step_2 = $val->step_2;
           $step_3 = $val->step_3;
           $statuses_id = $val->statuses_id;
           $created = $val->created;
           
           $dataArr = array(
                     
                     'theme_name' => $theme_name,
                     'step_1' => $step_1,
                     'step_2' => $step_2,
                     'step_3' => $step_3,
                     'statuses_id' => $statuses_id,
                     'created' => $created
                    
                        );
           
            $finalArr =  array_merge($arr7,$dataArr);   
            $newArr[] = $finalArr;
           }

         }
         
          $data['single_site'] = $newArr; 
         
         
         
         //get multiple site data
         $sitenewArr = array();
         $sitearr = array();
         $allsitenewArr = array();
         $alldatasitenewArr = array();
         $istearr['multiple_store_records'] = $this->Membershipmodel->fetchalldatawithcond('multiple_store_records','user_id',$userid);  
         if(!empty($istearr['multiple_store_records'])) {
         foreach($istearr['multiple_store_records'] as $key => $val) {
            
           $record_id = $val->id;  
           $user_id = $val->user_id;
           $no_of_stores = $val->no_of_stores;
           $step_1 = $val->step_1;
           $step_2 = $val->step_2;
           $step_3 = $val->step_3;
           $statuses_id = $val->statuses_id;
           
           $arr1 = array(
                   
                    'site_id' => $record_id,
                    'user_id' => $user_id,
                    'no_of_stores' => $no_of_stores,
                    'step_1' => $step_1,
                    'step_2' => $step_2,
                    'step_3' => $step_3,
                    'statuses_id' => $statuses_id
                    
                     );
                     
                     
           $cpanel_id = $val->cpanel_id;
           
           //get cpanel Details 
           $cpanel_details = $this->Membershipmodel->fetchtabledataone('cpanel','id',$cpanel_id);
           $cpanel_domain = $cpanel_details[0]->domain;
           $cpanel_domain_status = $cpanel_details[0]->status;
           
           $arr2 = array(
                     
                     'cpanel_domain' => $cpanel_domain,
                     'cpanel_domain_status' => $cpanel_domain_status
                   
                      );  
        
           $arr3 = array_merge($arr1,$arr2); 
           
           $amazon_id = $val->amazon_id;
           
           //get amazon details
           $amazon_details = $this->Membershipmodel->fetchtabledataone('amazon','id',$amazon_id);  
           if(!empty($amazon_details[0])){
            $amazon_region_id = $amazon_details[0]->region_id;
            $amazon_affiliate_tag = $amazon_details[0]->affiliate_tag;
            $amazon_access_key = $amazon_details[0]->access_key;
            $amazon_account_status = $amazon_details[0]->status;
           }
           else
           {
           $amazon_region_id = '';
           $amazon_affiliate_tag = '';
           $amazon_access_key = '';
           $amazon_account_status = '';
           }
           
           
           $arr4 = array(
                     
                     'amazon_region_id' => $amazon_region_id,
                     'amazon_affiliate_tag' => $amazon_affiliate_tag,
                     'amazon_access_key' => $amazon_access_key,
                     'amazon_account_status' => $amazon_account_status
                   
                      );  
           
           $arr5 = array_merge($arr3,$arr4);  
           
           
           $multiple_stores_details = $this->Membershipmodel->fetchtabledataone('multiple_stores','multiple_store_records_id',$record_id);  
           
           foreach($multiple_stores_details as $x => $val) {
               
               $multiple_stores_id = $val->id;
               
               $installation_path = $val->installation_path;
               $blog_title = $val->blog_title;
               $username = $val->username;
               $password = $val->password;
               $theme_id = $val->theme_id;
               $created = $val->created;
                
               $theme_details = $this->Membershipmodel->fetchtabledataone('themes','id',$theme_id);
               $theme_name = $theme_details[0]->name;
               
               
               $multiple_store_categories = $this->Membershipmodel->fetchtabledataone('multiple_store_categories','multiple_stores_id',$multiple_stores_id);
               
               
               $category = $multiple_store_categories[0]->category;
               $video_category = $multiple_store_categories[0]->video_category;
               $no_of_product = $multiple_store_categories[0]->no_of_products;
               $keyword = $multiple_store_categories[0]->keyword;
               
               
               $dataArr = array(
                     
                     'installation_path' => $installation_path,
                     'blog_title' => $blog_title,
                     'username' => $username,
                     'password' => $password,
                     'theme_name' => $theme_name,
                     'category' => $category,
                     'no_of_products' =>  $no_of_product,
                     'keyword' =>  $keyword,
                     'created'  => $created
                    
                        );
               
                $allsitenewArr['data'][$x] =  $dataArr;
              
               
           }
           
           $arr6 = array_merge($arr5,$allsitenewArr); 
          
           $alldatasitenewArr[$key] = $arr6;
           
          }
        }
          
           $data['multiple_sites'] = $alldatasitenewArr;
          
            $data['memberships'] = $this->Membershipmodel->getTable('membership_levels');
             $data['login_logs'] = $this->Membershipmodel->getTable('login_logs');  
           
           $data['membershipsselected'] =$this->Membershipmodel->fetchtabledataone('user_membership_levels','user_id',$userid);
            $arr = array();
           if(!empty($data['membershipsselected'])){
            foreach($data['membershipsselected'] as $ar){
             // $val = $ar->membership_level_id;
              array_push($arr,$ar->membership_level_id);

            }
          }
          $data['memarr'] = $arr;
           //echo'<pre>'; print_r($data['memarr']);exit;
           $this->load->view('admin/edit_user.php',$data);    
             }               
            }
           }
         else
          {
            redirect('admin/login.php');
          }
        }

       
        


        /**
         * Function: edit_user_profile
         *
         * This function will allow admin to update users account
         *
         * @param : null
         *
         * @return : null
        */
        public function edit_user_profile(){

          $is_admin = $this->session->userdata('is_admin');
          if( ($is_admin == 1) && ($this->input->post('type') == 'eu'))
           { 

            $update['username'] = $this->input->post('name');                       
            $update['status'] = $this->input->post('activate');
            $update['is_admin'] = $this->input->post('is_admin');
            $mem = $this->input->post('mem');
            $userid = $this->input->post('userid');
            $user_details = $this->Membershipmodel->fetchtabledataone('users','id',$userid);
            if($user_details == 0)
            {
                $data['status'] = 'error';
                $data['message'] = 'user does not exists';
                echo json_encode($data);die();
            }
            $update['registered_by'] = 'Super Admin';
            $update['modified'] = date('Y-m-d H:i:s');  
            $check = $this->Membershipmodel->updatetable('users',$update,'id',$userid);
            if($check != 0)
            {
              if(!empty($mem)){
                foreach($mem as $m){
                  $checkmem = array(
                    'user_id' => $userid,
                    'membership_level_id' => $m
                  );
                  $checkMembership =$this->Membershipmodel->exists('user_membership_levels',$checkmem);
						      if (empty($checkMembership)) {
                    $m_level =  array(
                      'user_id' => $userid,
                      'membership_level_id' =>  $m,
                      'assigned_by' => 'Super Admin'
                    );
                   $this->Membershipmodel->insertData('user_membership_levels',$m_level);
                  }else{
                    $this->Membershipmodel->delete('user_membership_levels',array('user_id'=>$userid));
                    if(!empty($mem)){
                      foreach($mem as $m){
                        $checkmem = array(
                          'user_id' => $userid,
                          'membership_level_id' => $m
                        );
                        $checkMembership =$this->Membershipmodel->exists('user_membership_levels',$checkmem);
                        if (empty($checkMembership)) {
                          $m_level =  array(
                            'user_id' => $userid,
                            'membership_level_id' =>  $m,
                            'assigned_by' => 'Super Admin'
                          );
                         $this->Membershipmodel->insertData('user_membership_levels',$m_level);
                        }
                      }
                     
                    } 
                    // $usermembe = $this->Membershipmodel->fetchtabledatatwo('user_membership_levels','membership_level_id',$m,'user_id',$userid);
                    // $update['assigned_by'] = 'Super Admin';
                    // $check = $this->Membershipmodel->updatetable('users',$update,'id',$usermembe[0]->id);
                  }
                }
               
              }
             
                $data['status'] = 'success';
                $data['message'] = 'Account edited successfully.';
            }
            else
            {
                $data['status'] = 'fail';
                $data['message'] = 'Something went wrong while updating account. Please try again.';
            }
            echo json_encode($data);die();
           }
          else
          {
            $data['status'] = 'fail';
            $data['message'] = 'Something went wrong while updating account. Please try again.';
            echo json_encode($data);die();
          }
         }
    

       

        /**
         * Function: change_user_passeword
         *
         * This function will allow to change user's current password
         *
         * @param : null
         *
         * @return : null
        */
        public function change_user_password(){   

          $is_admin = $this->session->userdata('is_admin');
          if(($is_admin == 1) && ($this->input->post('type') == 'cp')) { 

            $userid = $this->input->post('userid');   
            $password = $this->input->post('password');

            $options = array(
                 'salt' => $this->randomPassword(),
                 'cost' => 13 
            );

            $hash = password_hash($password, PASSWORD_DEFAULT, $options);

            $update['password'] = $hash;

            $check = $this->Membershipmodel->updatetable('users',$update,'id',$userid);

            if($check != 'error')
            {
                $data['status'] = 'success';
                $data['message'] = 'password has been changed successfully.';
            }
            else
            {
                $data['status'] = 'fail';
                $data['message'] = 'Something went wrong while changing the passowrd. Please try again.';
            }
            echo json_encode($data);die();
           }
          else
          {
            $data['status'] = 'fail';
            $data['message'] = 'Something went wrong while changing the passowrd. Please try again.';
            echo json_encode($data);die();
          }
        
         }


        
         /**
          * Function: master_login
          *
          * This function will load master login page view
         */
         public function master_login(){
           
            $this->load->view('admin/master_login.php');
            
          }

       

        //validate master login
        public function validate_master_login(){ 
            
            $admin_email = $this->input->post('admin_email'); 
            $admin_password = $this->input->post('admin_password'); 
            $user_email = $this->input->post('user_email');  
            $validateUseremail = $this->Membershipmodel->emailexits('users','email',$user_email);
            
            if(!$validateUseremail){
               $this->session->set_flashdata('error','Invalid username or password');
               redirect('login');
               die();
            }
            else{

            $user_id = $validateUseremail[0]->id;
            $validate = $this->Membershipmodel->validateAdminlogin($admin_email,$admin_password);
            if($validate != 0)
             {  
                 
                $storeuser = array( 
                                    'user_id'  => $user_id, 
                                    'account_type' => 'user',
                                    'is_admin' => 1,
                                    'role' =>  'super admin',
                                    'admin_email' => $admin_email,
                                    'email' => $user_email,
                                    'admin_id' => $validate,
                                    
                                );
                $this->session->set_flashdata('success','You are logged in on behalf of '.$user_email);
                $this->session->set_userdata($storeuser);
                redirect('dashboard');
             }
            else{
                
                 $this->session->set_flashdata('error','Invalid access ! Either email or password is incorrect');
                 redirect('master_login');
                 die();
               }
             }
            
           
           }


           //show notification view with details
           public function show_notificationview(){
               
              $notification_stats = $this->Membershipmodel->fetchalldata('notification_admin');
              $data['notification_count'] =  count($notification_stats); 
              $data['all_notification'] = $notification_stats;
              $this->load->view('admin/notification.php', $data);
           }



           //show edit notification
           public function edit_notification(){

             $id = $this->uri->segment(2);
             $notification_detail = $this->Membershipmodel->fetchtabledataone('notification_admin','id',$id);
             if($notification_detail)
              {
                  $data['notification_detail'] = $notification_detail;
                  $this->load->view('admin/edit_single_notification.php', $data);
              }
            }



           //edit notification details
           public function edit_single_notification(){
               
            $is_admin = $this->session->userdata('is_admin');
            if( ($is_admin == 1) && ($this->input->post('type') == 'eu')) { 

              $update['title'] =  $this->input->post('title');                    
              $update['message'] = $this->input->post('message');
              $update['status'] = $this->input->post('activate');
              $notification_id = $this->input->post('notification_id');
              $update['source'] = 'Super Admin';
              $update['modified'] = date('Y-m-d H:i:s');
              $check = $this->Membershipmodel->updatetable('notification_admin',$update,'id',$notification_id);
              if($check != 0)
              {
                  $data['status'] = 'success';
                  $data['message'] = 'Message edited successfully.';
              }
              else
              {
                 $data['status'] = 'fail';
                 $data['message'] = 'Something went wrong while updating message. Please try again.';
              }
              echo json_encode($data);die();
             }
             else
              {
                $data['status'] = 'fail';
                $data['message'] = 'Something went wrong while updating message. Please try again.';
                echo json_encode($data);die();
              }
            }
          

          

           //add notification
           public function add_notification(){  
               
              if($this->input->is_ajax_request()){   

                  $is_admin = $this->session->userdata('is_admin');
                  if(($is_admin == 1) && ($this->input->post('type') == 'cp')) {

                    $userid = $this->session->userdata['user_id'];
                    $insert['userid'] = $userid;
                    $insert['title'] = $this->input->post('title');
                    $insert['message'] = $this->input->post('message'); 
                    $insert['source'] = 'Super Admin';
                    $insert['status'] = $this->input->post('status');
                    $done = $this->Membershipmodel->insertData('notification_admin',$insert);

                    if($done != 0)
                    {   
                        $data['status'] = 'success';
                        $data['message'] = 'Message successfully added.';
                    }
                    else
                    {   
                        $data['status'] = 'fail';
                        $data['message'] = 'Something went wrong. Please try again';
                    }
                    echo json_encode($data);
                    die();
                  }
                }
              }

          

             //fetch all notifications 
            public function all_notifications(){
                 
             $is_admin = $this->session->userdata('is_admin');

               if($is_admin == 1 ){

                 $all_notifications = $this->Membershipmodel->fetchalldata('notification_admin');  
                 if(!empty($aweber)){
                     $data['all_notifications'] = $all_notifications;
                  }
                  else
                   {
                     $data['all_notifications'] = 0;
                   }
                  
                   $this->load->view('admin/all_notifications.php',$data); 

                }else

                  {
                     redirect('not_found');
                  }
              }
      

             

             //fetch all notifications 
             public function show_enabled_notifications(){
                 
              $is_admin = $this->session->userdata('is_admin');
               if($is_admin == 1) {
                $enabled_notifications = $this->Membershipmodel->fetchtabledataone('notification_admin','status','1');  
                 if(!empty($enabled_notifications)){
                     $data['enabled_notifications'] = $enabled_notifications;
                  }
                  else
                   {
                     $data['enabled_notifications'] = 0;
                   }
                  
                   $this->load->view('admin/enabled_notifications.php',$data); 

                }else
                  {
                     redirect('not_found');
                  }
              }



             //show total team members 
             public function show_total_team(){
                 
             $is_admin = $this->session->userdata('is_admin');
               if($is_admin == 1) {
                $virtual_account = $this->Membershipmodel->fetchalldata('virtual_accounts'); 
                 if(!empty($virtual_account)){
                     $data['virtual_account'] = $virtual_account;
                  }
                  else
                   {
                     $data['virtual_account'] = 0;
                   }
                  
                   $this->load->view('admin/total_teammembers.php',$data); 

                }else
                  {
                     redirect('not_found');
                  }
              }

         
         
         
             //show total team members 
             public function show_total_clients(){
                 
             $is_admin = $this->session->userdata('is_admin');
               if($is_admin == 1) {
                $client_account = $this->Membershipmodel->fetchalldata('client_accounts'); 
                 if(!empty($client_account)){
                     $data['client_account'] = $client_account;
                  }
                  else
                   {
                     $data['client_account'] = 0;
                   }
                  
                   $this->load->view('admin/total_clients.php',$data); 

                }else
                  {
                     redirect('not_found');
                  }
              }




               //show total amazon_accounts
             public function show_total_amazon(){
                 
              $is_admin = $this->session->userdata('is_admin');
               if($is_admin == 1) {
                $amazon_data = $this->Membershipmodel->fetchalldata('amazon');
                $arr = array();

                foreach($amazon_data as $key => $val){

                 $get_user_email = $this->Membershipmodel->fetchtabledataone('users','id',$val->user_id);

                 $get_amazon_region = $this->Membershipmodel->fetchtabledataone('amazon_region','id',$val->region_id);

                 $email = $get_user_email[0]->email;
                 $amazon_region = $get_amazon_region[0]->country;
                 $data = array(
                            'user_id'=>$val->user_id,
                            'amazon_region' => $amazon_region,
                            'affiliate_tag' =>$val->affiliate_tag,
                            'status' => $val->status,
                            'region_id' => $val->region_id,
                            'created' =>$val->created,
                            'email' => $email
                           );

                 $arr[$key] = $data;
                  }
                  
                 if(!empty($arr)){
                     $data_amazon['client_account'] = $arr;
                  }
                  else
                   {
                     $data_amazon['client_account'] = 0;
                   }
                  
                   $this->load->view('admin/total_amazon_accounts.php',$data_amazon); 

                }else
                  {
                     redirect('not_found');
                  }
              }


              // show total envato account
            public function show_total_envato()
            {
                $is_admin = $this->session->userdata('is_admin');
                if($is_admin == 1) {
                    $amazon_data = $this->Membershipmodel->fetchalldata('envato');
                    $arr = array();

                    foreach($amazon_data as $key => $val){

                        $get_user_email = $this->Membershipmodel->fetchtabledataone('users','id',$val->user_id);

                        $get_envato = $this->Membershipmodel->fetchtabledataone('envato','user_id',$val->user_id);

                        $email = $get_user_email[0]->email;

                        $data = array(
                            'user_id'=>$val->user_id,
                            'username' => $get_envato[0]->username,
                            'status' => $get_envato[0]->status,
                            'created' =>$val->created,
                            'email' => $email
                        );

                        $arr[$key] = $data;
                    }


                    if(!empty($arr)){
                        $data_amazon['client_account'] = $arr;
                    }
                    else
                    {
                        $data_amazon['client_account'] = 0;
                    }

                    $this->load->view('admin/total_envato_accounts.php',$data_amazon);

                }else
                {
                    redirect('not_found');
                }
            }




             //fetch send grid details
             public function show_users_details(){
                 
              $is_admin = $this->session->userdata('is_admin');
               if($is_admin == 1){
                 $users = $this->Membershipmodel->fetchalldata('users'); 
                 if(!empty($users)){
                     $data['users'] = $users;
                  }
                  else
                   {
                     $data['users'] = 0;
                   }
                  
                   $this->load->view('admin/users.php',$data); 

                }else
                  {
                     redirect('not_found');
                  }
              }


              
             //fetch enabled user details
             public function show_enabled_users_details(){
                 
              $is_admin = $this->session->userdata('is_admin');
               
               if($is_admin == 1){
                 $enabled_users = $this->Membershipmodel->fetchtabledataone('users','status','1');
                 if(!empty($enabled_users)){
                     $data['enabled_users'] = $enabled_users;
                  }
                  else
                   {
                     $data['enabled_users'] = 0;
                   }
                  
                   $this->load->view('admin/enabled_users.php',$data); 

                }else
                  {
                     redirect('not_found');
                  }
              }



             //fetch disabled user details
             public function show_disabled_users_details(){
                
               $is_admin = $this->session->userdata('is_admin');
               if($is_admin == 1){
                 $disabled_users = $this->Membershipmodel->fetchtabledataone('users','status','0');
                 if(!empty($disabled_users)){
                     $data['disabled_users'] = $disabled_users;
                  }
                  else
                   {
                     $data['disabled_users'] = 0;
                   }
                  
                   $this->load->view('admin/disabled_users.php',$data); 

                }else
                  {
                     redirect('not_found');
                  }
              }


             //fetch active user details
             public function show_active_users_details(){
              
              $is_admin = $this->session->userdata('is_admin');
               if($is_admin == 1){
                 $user_active = $this->Membershipmodel->fetchtabledataone('users','status','1');
                 if(!empty($user_active)){
                     $data['user_active'] = $user_active;
                  }
                  else
                   {
                     $data['user_active'] = 0;
                   }
                  
                   $this->load->view('admin/user_active.php',$data); 

                }else
                  {
                     redirect('not_found');
                  }
              }

            
             public function filter(){
               $this->load->view('admin/filter.php'); 
              }

             

             public function search_details(){
                 
                    $is_admin = $this->session->userdata('is_admin'); 
                    if($is_admin == 1){
                      
                    $data['date1'] = $_GET['to']; 
                    $data['date2'] = $_GET['from']; 
                    $filterdata = $_GET['filter'];
                    if($filterdata === "users"){

                       $table = 'users';
                       $user_details['user_details'] = $this->Membershipmodel->show_data_by_date_range($data,$table);
                       $this->load->view('admin/filter.php',$user_details); 
                     }


                    if($filterdata === "single_site_details"){
                      $table = 'records';
                      $single_site_details['single_site_details'] = $this->Membershipmodel->show_data_by_date_range($data,$table);

                      $newArr = array();
                      $arr = array();
                      
                     foreach($single_site_details['single_site_details'] as $x => $val) {
            
                      $record_id = $val->id;  
                      $user_id = $val->user_id;
                      $blog_title = $val->blog_title;
                      $installation_path = $val->installation_path;
           
                      $arr1 = array(
                   
                       'site_id' => $record_id,
                       'user_id' => $user_id,
                       'blog_title' => $blog_title,
                       'installation_path' => $installation_path,
                       'installation_path' => $installation_path,
                    
                      );
                     
                     $cpanel_id = $val->cpanel_id;
           
                     //get cpanel Details 
                     $cpanel_details = $this->Membershipmodel->fetchtabledataone('cpanel','id',$cpanel_id);
                     $cpanel_domain = $cpanel_details[0]->domain;
                     $cpanel_domain_status = $cpanel_details[0]->status;
           
                     $arr2 = array(
                     
                       'cpanel_domain' => $cpanel_domain,
                       'cpanel_domain_status' => $cpanel_domain_status
                   
                      );
        
                     $arr3 = array_merge($arr1,$arr2);
            
            
           
                     $amazon_id = $val->amazon_id;
           
                      //get amazon details
                      $amazon_details = $this->Membershipmodel->fetchtabledataone('amazon','id',$amazon_id);  
                      $amazon_region_id = $amazon_details[0]->region_id;
                      $amazon_affiliate_tag = $amazon_details[0]->affiliate_tag;
                      $amazon_access_key = $amazon_details[0]->access_key;
                      $amazon_account_status = $amazon_details[0]->status;
             
                      $arr4 = array(
                       
                         'amazon_region_id' => $amazon_region_id,
                         'amazon_affiliate_tag' => $amazon_affiliate_tag,
                         'amazon_access_key' => $amazon_access_key,
                         'amazon_account_status' => $amazon_account_status
                     
                        );
           
                      $arr5 = array_merge($arr3,$arr4);     
             
                      $wordpress_id = $val->wordpress_id;
             
                      //get wordpress details
                      $wordpress_details = $this->Membershipmodel->fetchtabledataone('wordpress','id',$wordpress_id); 
                      $site_username = $wordpress_details[0]->username;
                      $sitepassword = $wordpress_details[0]->password;
             
                      $arr6 = array(
                       
                         'site_username' => $site_username,
                         'sitepassword' => $sitepassword
                      
                       );
                     
                       $arr7 = array_merge($arr5,$arr6);    
               
                       $theme_id = $val->theme_id;
               
                       //get theme details
                       $theme_details = $this->Membershipmodel->fetchtabledataone('themes','id',$theme_id);
                       $theme_name = $theme_details[0]->name;  
               
                       $step_1 = $val->step_1;
                       $step_2 = $val->step_2;
                       $step_3 = $val->step_3;
                       $statuses_id = $val->statuses_id;
                       $created = $val->created;
               
                       $dataArr = array(
                         
                         'theme_name' => $theme_name,
                         'step_1' => $step_1,
                         'step_2' => $step_2,
                         'step_3' => $step_3,
                         'statuses_id' => $statuses_id,
                         'created' => $created
                        
                            );
           
                        $finalArr =  array_merge($arr7,$dataArr);   
                        $newArr[] = $finalArr;
                      }
         
                       $data['single_site'] = $newArr;  

                      $this->load->view('admin/filter.php',$data); 
                    
                    }


                    


                    if($filterdata === "multiple_site_details"){
                       
                       $table = 'multiple_store_records';
                       $multiple_stores['multiple_stores'] = $this->Membershipmodel->show_data_by_date_range($data,$table);
                       
                       $sitenewArr = array();
                       $sitearr = array();
                       $allsitenewArr = array();

                      foreach($multiple_stores['multiple_stores'] as $key => $val) {
            
                         $record_id = $val->id;  
                         $user_id = $val->user_id;
                         $no_of_stores = $val->no_of_stores;
                         $step_1 = $val->step_1;
                         $step_2 = $val->step_2;
                         $step_3 = $val->step_3;
                         $statuses_id = $val->statuses_id;
           
                         $arr1 = array(
                                 
                                  'site_id' => $record_id,
                                  'user_id' => $user_id,
                                  'no_of_stores' => $no_of_stores,
                                  'step_1' => $step_1,
                                  'step_2' => $step_2,
                                  'step_3' => $step_3,
                                  'statuses_id' => $statuses_id
                                  
                                   );
                     
                     
                         $cpanel_id = $val->cpanel_id;
                         
                         //get cpanel Details 
                         $cpanel_details = $this->Membershipmodel->fetchtabledataone('cpanel','id',$cpanel_id);
                         $cpanel_domain = $cpanel_details[0]->domain;
                         $cpanel_domain_status = $cpanel_details[0]->status;
                         
                         $arr2 = array(
                                   
                                   'cpanel_domain' => $cpanel_domain,
                                   'cpanel_domain_status' => $cpanel_domain_status
                                 
                                    );  
        
                         $arr3 = array_merge($arr1,$arr2); 
                         
                         $amazon_id = $val->amazon_id;
                         
                         //get amazon details
                         $amazon_details = $this->Membershipmodel->fetchtabledataone('amazon','id',$amazon_id);  
                         $amazon_region_id = $amazon_details[0]->region_id;
                         $amazon_affiliate_tag = $amazon_details[0]->affiliate_tag;
                         $amazon_access_key = $amazon_details[0]->access_key;
                         $amazon_account_status = $amazon_details[0]->status;
           
                         $arr4 = array(
                                   
                                   'amazon_region_id' => $amazon_region_id,
                                   'amazon_affiliate_tag' => $amazon_affiliate_tag,
                                   'amazon_access_key' => $amazon_access_key,
                                   'amazon_account_status' => $amazon_account_status
                                 
                                    );  
           
                         $arr5 = array_merge($arr3,$arr4);  
                         
                         
                         $multiple_stores_details = $this->Membershipmodel->fetchtabledataone('multiple_stores','multiple_store_records_id',$record_id);  
           
                         foreach($multiple_stores_details as $x => $val) {
                             
                             $multiple_stores_id = $val->id;
                             
                             $installation_path = $val->installation_path;
                             $blog_title = $val->blog_title;
                             $username = $val->username;
                             $password = $val->password;
                             $theme_id = $val->theme_id;
                             $created = $val->created;
                              
                             $theme_details = $this->Membershipmodel->fetchtabledataone('themes','id',$theme_id);
                             $theme_name = $theme_details[0]->name;
                             
                             
                             $multiple_store_categories = $this->Membershipmodel->fetchtabledataone('multiple_store_categories','multiple_stores_id',$multiple_stores_id);
                             
                             
                             $category = $multiple_store_categories[0]->category;
                             $video_category = $multiple_store_categories[0]->video_category;
                             $no_of_product = $multiple_store_categories[0]->no_of_products;
                             $keyword = $multiple_store_categories[0]->keyword;
               
               
                             $dataArr = array(
                                   
                                   'installation_path' => $installation_path,
                                   'blog_title' => $blog_title,
                                   'username' => $username,
                                   'password' => $password,
                                   'theme_name' => $theme_name,
                                   'category' => $category,
                                   'no_of_products' =>  $no_of_product,
                                   'keyword' =>  $keyword,
                                   'created'  => $created
                                  
                                      );
                             
                              $allsitenewArr['data'][$x] =  $dataArr;
              
               
                               }
                               
                               $arr6 = array_merge($arr5,$allsitenewArr); 
                              
                               $alldatasitenewArr[$key] = $arr6;
                               
                              }
          
                           $data['multiple_sites'] = $alldatasitenewArr;
                           $this->load->view('admin/filter.php',$data); 
                      }


                     
                     if($filterdata === "cpanel_details"){
                       $table = 'cpanel';
                       $get_cpanel['get_cpanel'] = $this->Membershipmodel->show_data_by_date_range($data,$table);
                       
                       $arr = array();
                       foreach ($get_cpanel['get_cpanel'] as $key => $val) {
                         
                       $get_user_email = $this->Membershipmodel->fetchtabledataone('users','id',$val->user_id); 
                       $email = $get_user_email[0]->email;
             
                       $data = array(
                          'user_id'=>$val->user_id,
                          'domain' => $val->domain,
                          'status' => $val->status,
                          'created' =>$val->created,
                          'email' => $email
                         );
                   
                         $arr[$key] = $data;
                       }
                          
                         $cpanel_details['cpanel_details'] = $arr;
                         $this->load->view('admin/filter.php',$cpanel_details); 
                      }

                     

                     
                     if($filterdata === "amazon_details"){
                       $table = 'amazon';
                       $amazon_ac['amazon_details'] = $this->Membershipmodel->show_data_by_date_range($data,$table);

                       $arr = array();
                       foreach($amazon_ac['amazon_details'] as $key => $val){
                       
                       $get_user_email = $this->Membershipmodel->fetchtabledataone('users','id',$val->user_id); 

                       $get_amazon_region = $this->Membershipmodel->fetchtabledataone('amazon_region','id',$val->region_id); 
                 
                       $email = $get_user_email[0]->email;
                       $amazon_region = $get_amazon_region[0]->country;
                       $data = array(
                              'user_id'=>$val->user_id,
                              'amazon_region' => $amazon_region,
                              'affiliate_tag' =>$val->affiliate_tag,
                              'status' => $val->status,
                              'region_id' => $val->region_id,
                              'created' =>$val->created,
                              'email' => $email
                             );
                       
                            $arr[$key] = $data;
                        }
                       
                       $get_amazon_details['get_amazon_details'] = $arr;
                       $this->load->view('admin/filter.php',$get_amazon_details); 
                     }
                    



                     if($filterdata === "virtual_details"){
                       $table = 'virtual_accounts';
                       $virtual_details['virtual_details'] = $this->Membershipmodel->show_data_by_date_range($data,$table);

                       foreach ($virtual_details['virtual_details'] as $key => $val) {

                        $get_user_email = $this->Membershipmodel->fetchtabledataone('users','id',$val->user_id); 
                        
                        $data = array(

                            'user_id'=>$val->id,
                            'client_name' => $val->username,
                            'client_email' =>$val->email,
                            'status' => $val->status,
                            'is_deleted' => $val->is_deleted,
                            'created' =>$val->created,
                            'modified' =>$val->modified,
                            'email' => $get_user_email[0]->email
                           );
                     
                          $arr[$key] = $data;

                        } 
                         $virtual_account_details['virtual_account_details'] = $arr;
                         $this->load->view('admin/filter.php',$virtual_account_details); 
                     }




                     if($filterdata === "client_details"){
                       $table = 'client_accounts';
                       $client_details['client_details'] = $this->Membershipmodel->show_data_by_date_range($data,$table);
                       
                       $arr = array();
                       foreach ($client_details['client_details'] as $key => $val) {
                          
                       $get_user_email = $this->Membershipmodel->fetchtabledataone('users','id',$val->user_id); 
                          
                        $data = array(

                                'user_id'=>$val->id,
                                'client_name' => $val->username,
                                'client_email' =>$val->email,
                                'status' => $val->status,
                                'is_deleted' => $val->is_deleted,
                                'created' =>$val->created,
                                'modified' =>$val->modified,
                                'email' => $get_user_email[0]->email
                              );
                       
                          $arr[$key] = $data;
                        }

                          $client_search_details['client_search_details'] = $arr;
                          $this->load->view('admin/filter.php',$client_search_details); 
                     }



                        if($filterdata == "disabled_users"){
                            $table = 'users';
                            $disabled_users['disabled_users'] = $this->Membershipmodel->show_data_by_date_range($data,$table);

                            $arr = array();
                            foreach ($disabled_users['disabled_users'] as $key => $val){

                                if($val->is_deleted == 1){

                                    $data = array(
                                        'id'=>$val->id,
                                        'username' => $val->username,
                                        'email' => $val->email,
                                        'registered_by' => $val->registered_by,
                                        'is_deleted' => $val->is_deleted,
                                        'created' => $val->created
                                    );
                                    $arr[$key] = $data;
                                }
                            }

                            $disabled_account_users['disabled_account_users'] = $arr;
                            $this->load->view('admin/filter.php',$disabled_account_users);

                        }

                        if($filterdata == 'active_users'){
                            $table = "login_logs";
                            $active_users_data['active_users_data'] = $this->Membershipmodel->activeUsersFromData($table,$data['date1'],$data['date2']);

                            $this->load->view('admin/filter.php',$active_users_data);

                        }


                        if($filterdata == "failed_single"){
                            $table = 'records';
                            $failed_single['failed_single'] = $this->Membershipmodel->show_data_by_date_range($data,$table);

                            $newArr = array();
                            $arr = array();

                            foreach($failed_single['failed_single'] as $x => $val) {

                                if ($val->failed == 1) {

                                    $record_id = $val->id;
                                    $user_id = $val->user_id;
                                    $blog_title = $val->blog_title;
                                    $installation_path = $val->installation_path;

                                    $arr1 = array(

                                        'site_id' => $record_id,
                                        'user_id' => $user_id,
                                        'blog_title' => $blog_title,
                                        'installation_path' => $installation_path,
                                    );

                                    $cpanel_id = $val->cpanel_id;

                                    //get cpanel Details
                                    $cpanel_details = $this->Membershipmodel->fetchtabledataone('cpanel', 'id', $cpanel_id);
                                    $cpanel_domain = $cpanel_details[0]->domain;
                                    $cpanel_domain_status = $cpanel_details[0]->status;

                                    $arr2 = array(

                                        'cpanel_domain' => $cpanel_domain,
                                        'cpanel_domain_status' => $cpanel_domain_status

                                    );

                                    $arr3 = array_merge($arr1, $arr2);


                                    $amazon_id = $val->amazon_id;

                                    //get amazon details
                                    $amazon_details = $this->Membershipmodel->fetchtabledataone('amazon', 'id', $amazon_id);
                                    $amazon_region_id = $amazon_details[0]->region_id;
                                    $amazon_affiliate_tag = $amazon_details[0]->affiliate_tag;
                                    $amazon_access_key = $amazon_details[0]->access_key;
                                    $amazon_account_status = $amazon_details[0]->status;

                                    $arr4 = array(

                                        'amazon_region_id' => $amazon_region_id,
                                        'amazon_affiliate_tag' => $amazon_affiliate_tag,
                                        'amazon_access_key' => $amazon_access_key,
                                        'amazon_account_status' => $amazon_account_status

                                    );

                                    $arr5 = array_merge($arr3, $arr4);

                                    $wordpress_id = $val->wordpress_id;

                                    //get wordpress details
                                    $wordpress_details = $this->Membershipmodel->fetchtabledataone('wordpress', 'id', $wordpress_id);
                                    $site_username = $wordpress_details[0]->username;
                                    $sitepassword = $wordpress_details[0]->password;

                                    $arr6 = array(

                                        'site_username' => $site_username,
                                        'sitepassword' => $sitepassword

                                    );

                                    $arr7 = array_merge($arr5, $arr6);

                                    $theme_id = $val->theme_id;

                                    //get theme details
                                    $theme_details = $this->Membershipmodel->fetchtabledataone('themes', 'id', $theme_id);
                                    $theme_name = $theme_details[0]->name;

                                    $step_1 = $val->step_1;
                                    $step_2 = $val->step_2;
                                    $step_3 = $val->step_3;
                                    $message = $val->message;
                                    $statuses_id = $val->statuses_id;
                                    $created = $val->created;

                                    $dataArr = array(

                                        'theme_name' => $theme_name,
                                        'step_1' => $step_1,
                                        'step_2' => $step_2,
                                        'step_3' => $step_3,
                                        'message' => $message,
                                        'statuses_id' => $statuses_id,
                                        'created' => $created
                                    );

                                    $finalArr = array_merge($arr7, $dataArr);
                                    $newArr[] = $finalArr;
                                }

                            }
                            $data['single_site_failed'] = $newArr;

                            $this->load->view('admin/filter.php',$data);

                        }


                        if($filterdata === "failed_multi"){

                            $table = 'multiple_store_records';
                            $multiple_stores['multiple_stores'] = $this->Membershipmodel->show_data_by_date_range($data,$table);

                            $sitenewArr = array();
                            $sitearr = array();
                            $allsitenewArr = array();

                            foreach($multiple_stores['multiple_stores'] as $key => $val) {

                                $multiple_stores_data = $this->Membershipmodel->fetchtabledataone('multiple_stores', 'multiple_store_records_id', $val->id);

                                foreach ($multiple_stores_data as $key2 => $value){
                                    echo $value->status;

                                    if($value->status == 1) {

                                        $record_id = $val->id;
                                        $user_id = $val->user_id;
                                        $no_of_stores = $val->no_of_stores;
                                        $step_1 = $val->step_1;
                                        $step_2 = $val->step_2;
                                        $step_3 = $val->step_3;
                                        $statuses_id = $val->statuses_id;

                                        $arr1 = array(

                                            'site_id' => $record_id,
                                            'user_id' => $user_id,
                                            'no_of_stores' => $no_of_stores,
                                            'step_1' => $step_1,
                                            'step_2' => $step_2,
                                            'step_3' => $step_3,
                                            'statuses_id' => $statuses_id
                                        );


                                        $cpanel_id = $val->cpanel_id;

                                        //get cpanel Details
                                        $cpanel_details = $this->Membershipmodel->fetchtabledataone('cpanel', 'id', $cpanel_id);
                                        $cpanel_domain = $cpanel_details[0]->domain;
                                        $cpanel_domain_status = $cpanel_details[0]->status;

                                        $arr2 = array(

                                            'cpanel_domain' => $cpanel_domain,
                                            'cpanel_domain_status' => $cpanel_domain_status

                                        );

                                        $arr3 = array_merge($arr1, $arr2);

                                        $amazon_id = $val->amazon_id;

                                        //get amazon details
                                        $amazon_details = $this->Membershipmodel->fetchtabledataone('amazon', 'id', $amazon_id);
                                        $amazon_region_id = $amazon_details[0]->region_id;
                                        $amazon_affiliate_tag = $amazon_details[0]->affiliate_tag;
                                        $amazon_access_key = $amazon_details[0]->access_key;
                                        $amazon_account_status = $amazon_details[0]->status;

                                        $arr4 = array(

                                            'amazon_region_id' => $amazon_region_id,
                                            'amazon_affiliate_tag' => $amazon_affiliate_tag,
                                            'amazon_access_key' => $amazon_access_key,
                                            'amazon_account_status' => $amazon_account_status

                                        );

                                        $arr5 = array_merge($arr3, $arr4);


                                        $multiple_stores_details = $this->Membershipmodel->fetchtabledataone('multiple_stores', 'multiple_store_records_id', $record_id);

                                        foreach ($multiple_stores_details as $x => $val) {

                                            $multiple_stores_id = $val->id;

                                            $installation_path = $val->installation_path;
                                            $blog_title = $val->blog_title;
                                            $username = $val->username;
                                            $password = $val->password;
                                            $theme_id = $val->theme_id;
                                            $message = $val->message;
                                            $created = $val->created;

                                            $theme_details = $this->Membershipmodel->fetchtabledataone('themes', 'id', $theme_id);
                                            $theme_name = $theme_details[0]->name;


                                            $multiple_store_categories = $this->Membershipmodel->fetchtabledataone('multiple_store_categories', 'multiple_stores_id', $multiple_stores_id);


                                            $category = $multiple_store_categories[0]->category;
                                            $video_category = $multiple_store_categories[0]->video_category;
                                            $no_of_product = $multiple_store_categories[0]->no_of_products;
                                            $keyword = $multiple_store_categories[0]->keyword;


                                            $dataArr = array(

                                                'installation_path' => $installation_path,
                                                'blog_title' => $blog_title,
                                                'username' => $username,
                                                'password' => $password,
                                                'theme_name' => $theme_name,
                                                'message' => $message,
                                                'category' => $category,
                                                'no_of_products' => $no_of_product,
                                                'keyword' => $keyword,
                                                'created' => $created
                                            );

                                            $allsitenewArr['data'][$x] = $dataArr;


                                        }
                                        $arr6 = array_merge($arr5,$allsitenewArr);

                                        $alldatasitenewArr[$key] = $arr6;
                                    }
                                }


                            }

                            $data['failed_multi'] = $alldatasitenewArr;
                            $this->load->view('admin/filter.php',$data);
                        }





                  }
                }
              


            
             //fetch user login log details
             public function user_login_logs(){
                 
              $is_admin = $this->session->userdata('is_admin');
               if($is_admin == 1){
                 $user_logs = $this->Membershipmodel->fetchalldata('login_logs'); 
                 if(!empty($user_logs)){
                     $data['user_logs'] = $user_logs;
                  }
                  else
                   {
                     $data['user_logs'] = 0;
                   }
                  
                   $this->load->view('admin/user_login_logs.php',$data); 

                }else
                  {
                     redirect('not_found');
                  }
              }


              public function active_user_logs(){
                  
              $is_admin = $this->session->userdata('is_admin');
               if($is_admin == 1){
                 
                 $data =  date('Y-m-d H:i:s', strtotime("-3 days"));
                 $user_logs = $this->Membershipmodel->fetchallactiveusersdata('login_logs',$data); 
                 if(!empty($user_logs)){
                    $userdata['userdata'] = $user_logs; 
                    $this->load->view('admin/logs.php',$userdata); 
                  }
                 
                }
              }
              
              
              


}
	
