<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'UsersController/login';

$route['dashboard'] = 'UsersController/index';
$route['password-update'] = 'UsersController/passwordUpdate';
$route['login'] = 'UsersController/login';
$route['profile'] = 'UsersController/profile';
$route['change-password'] = 'UsersController/changePassword';
$route['pro-machine'] = 'UsersController/proMachine';
$route['change-password'] = 'UsersController/change_password';
$route['find_account'] = 'UsersController/forgot_password';
$route['reset_password'] = 'UsersController/reset_password';
$route['terms'] = 'UsersController/terms';
$route['privacy'] = 'UsersController/privacy';
$route['detailed_privacy'] = 'UsersController/detailedPrivacy';
$route['feedback'] = 'UsersController/feedback';
$route['timeline'] = 'UsersController/timelineUpdate';
$route['disable'] = 'UsersController/disableAccount';
$route['delete'] = 'UsersController/deleteAccount';
$route['client_account'] = 'UsersController/clientAccount';
$route['team_member'] = 'UsersController/virtualAccount';
$route['delete_virtual'] = 'UsersController/deleteVirtual';
$route['delete_client'] = 'UsersController/deleteClient';
$route['download-account-data'] = 'UsersController/download_my_data';
$route['change_email'] = 'UsersController/changeEmail';
$route['logout'] = 'UsersController/logout';
$route['user_reset_password'] = 'UsersController/user_reset_password';
$route['tutorials'] = 'UsersController/tutorials';
$route['wl-rebranding'] = 'UsersController/wl_rebranding';
$route['wl-rebranding-remove/(:num)'] = 'UsersController/wl_rebranding_remove/$1';

$route['client-single-site'] = 'ClientAccountController/viewSingleStores';
$route['client-multiple-site'] = 'ClientAccountController/viewMultipleStores';

//gethost routes
$route['gethost'] = 'HostController/index';

//cPanel routes
$route['cpanel-view'] = 'CpanelController/index';
$route['cpanel/add'] = 'CpanelController/add';
$route['cpanel/delete'] = 'CpanelController/delete';

//amazon routes
$route['amazon'] = 'AmazonController/index';
$route['amazon/add'] = 'AmazonController/add';
$route['amazon/delete'] = 'AmazonController/delete';

//single site routes
$route['create-site'] = 'SingleSiteController/index';
$route['view-site'] = 'SingleSiteController/view_stores';
$route['category'] = 'SingleSiteController/amazon_category';
$route['theme'] = 'SingleSiteController/choose_theme';
$route['buttons'] = 'SingleSiteController/chooseButton';
$route['action'] = 'SingleSiteController/action';
$route['delete_store'] = 'SingleSiteController/deleteStore';

$route['assign_user_list'] = 'SingleSiteController/assignUserList';
$route['assign_store'] = 'SingleSiteController/storeClientAssign';
$route['site-logo'] = 'SingleSiteController/siteLogo';

$route['single_custom'] = 'SingleSiteController/single_custom';
$route['watch'] = 'SingleSiteController/preview';
$route['load_more'] = 'SingleSiteController/load_more';

$route['edit-single-site'] = 'SingleSiteController/editSingleSite';
$route['edit-category'] = 'SingleSiteController/editCategory';


$route['edit-host-details'] = 'SingleSiteController/editHostDetails';

$route['multiple_stores/details'] = 'MultipleSiteController/storeDetails';
$route['multiple_stores/create'] = 'MultipleSiteController/createSites';

$route['edit-multiple-site'] = 'MultipleSiteController/editMultipleSite';
$route['edit-site-category'] = 'MultipleSiteController/editMultiSiteCategory';

//multiple sites
$route['multiple_sites'] = 'MultipleSiteController/index';
$route['multiple_sites/create'] = 'MultipleSiteController/createSites';

$route['multiple_stores/savestores'] = 'MultipleSiteController/saveStores';
$route['multiple_stores/themes'] = 'MultipleSiteController/chooseThemes';
$route['multiple_stores/buttons'] = 'MultipleSiteController/chooseButtons';

$route['multiple_sites/view-sites'] = 'MultipleSiteController/viewStores';
$route['assign_user_list/(:any)'] = 'MultipleSiteController/assignUserList';
$route['multiple_stores/assign_user_list'] = 'MultipleSiteController/assignUserList';
$route['multiple_stores/assign_store'] = 'MultipleSiteController/multiStoreClientAssign';
$route['multiple_stores/site-logo'] = 'MultipleSiteController/siteLogo';
$route['multiple_stores/action'] = 'MultipleSiteController/action';



$route['client/dashboard'] = 'ClientAccountController/index';
$route['client/single_stores'] = 'ClientAccountController/viewSingleStores';
$route['client/multiple_stores'] = 'ClientAccountController/viewMultipleStores';




//single site testing
$route['site'] = 'CreateSiteCronController/SingleSiteCreate';
$route['post'] = 'CreatePostCronController/index';

//multiple site testing
$route['sites'] = 'CreateMultiSiteCronController/index';
$route['posts'] = 'CreateMultiSitePostCronController/index';









$route['admin_dashboard'] = 'Admin/dashboard';
$route['add_user'] = 'Admin/add_user';
$route['add_new_user'] = 'Admin/add_new_user';
$route['edit_user/:any'] = 'Admin/edit_user/$1';  
$route['edit_user_profile'] = 'Admin/edit_user_profile';  
$route['change_user_password'] = 'Admin/change_user_password';
$route['master_login'] = 'Admin/master_login';
$route['validate_master_login'] = 'Admin/validate_master_login';
$route['notification'] = 'Admin/show_notificationview';
$route['edit_notification/:any'] = 'Admin/edit_notification/$1';
$route['edit_single_notification'] = 'Admin/edit_single_notification';
$route['add_notification'] = 'Admin/add_notification';
$route['all_notifications'] = 'Admin/all_notifications';
$route['enabled_notifications'] = 'Admin/enabled_notifications';
$route['total_team_members'] = 'Admin/total_team_members';
$route['client_accounts'] = 'Admin/client_accounts';
$route['enabled_notifications'] = 'Admin/show_enabled_notifications';
$route['total_team_members'] = 'Admin/show_total_team';
$route['total_clients'] = 'Admin/show_total_clients';


$route['all_users'] = 'Admin/show_users_details';
$route['enabled_users'] = 'Admin/show_enabled_users_details';
$route['disabled_users'] = 'Admin/show_disabled_users_details';
$route['active_users'] = 'Admin/active_user_logs';
$route['filter'] = 'Admin/filter';
$route['login_logs'] = 'Admin/user_login_logs'; 
$route['total_amazon_connected'] = 'Admin/show_total_amazon';
$route['total_envato_connected'] = 'Admin/show_total_envato';


// Envato Routes
$route['envato'] = 'EnvatoController/index';
$route['envato-callback'] = 'EnvatoController/callback';
$route['login-envato'] = 'EnvatoController/loginEnvato';
$route['delete-envato-account'] = 'EnvatoController/delete';
$route['envato-success'] = 'EnvatoController/envatoSuccess';

// Impact
$route['impact'] = 'ImpactController/index';
$route['delete-impact-link'] = 'ImpactController/delete';

$route['wfsipn'] = 'PKController/index';


$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
